/**
 * @file IEvolutionGeniviDbusDidCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Did.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Did.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_DID_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_DID_CALLBACK_IF_H_

#include "org/alps/evo/DIDProxy.h"

using namespace ::org::alps::evo::DID;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for Did.
 */
class IEvolutionGeniviDbusDidCallbackIf :
   // from org/alps/evo/DIDProxy.h --- start
   public BtApplDidSetReqCallbackIF,
   public BtApplDidSetCfmCallbackIF
   // from org/alps/evo/DIDProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusDidCallbackIf() {}

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/alps/evo/DIDProxy implementation --- start
   virtual void onBtApplDidSetReqError(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetReqError >& error) = 0;

   virtual void onBtApplDidSetReqResponse(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetReqResponse >& response) = 0;

   virtual void onBtApplDidSetCfmError(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetCfmError >& error) = 0;

   virtual void onBtApplDidSetCfmSignal(const ::boost::shared_ptr< DIDProxy >& proxy, const ::boost::shared_ptr< BtApplDidSetCfmSignal >& signal) = 0;
   // org/alps/evo/DIDProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_DID_CALLBACK_IF_H_
