/**
 * @file IEvolutionGeniviDbusDeviceCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for Device.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for Device.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_DEVICE_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_DEVICE_CALLBACK_IF_H_

#include "org/bluez/Device1Proxy.h"

using namespace ::org::bluez::Device1;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for Device.
 */
class IEvolutionGeniviDbusDeviceCallbackIf :
   // from org/bluez/Device1Proxy.h --- start
   public ConnectCallbackIF,
   public DisconnectCallbackIF,
   public PairCallbackIF,
   public CancelPairingCallbackIF,
   public DiscoverServicesCallbackIF,
   public CancelDiscoveryCallbackIF,
   public ReportLinkkeyCallbackIF,
   public IncomingPairingCompCallbackIF,
   public AddressCallbackIF,
   public ClassCallbackIF,
   public IconCallbackIF,
   public UUIDsCallbackIF,
   public PairedCallbackIF,
   public ConnectedCallbackIF,
   public TrustedCallbackIF,
   public BlockedCallbackIF,
   public AliasCallbackIF,
   public AdapterCallbackIF,
   public ModaliasCallbackIF,
   public RSSICallbackIF,
   public VendorCallbackIF,
   public VendorSourceCallbackIF,
   public ProductCallbackIF,
   public MapInfoCallbackIF,
   public ConnectedServiceCallbackIF,
   public VersionCallbackIF,
   public PBAPInfoCallbackIF,
   public ModeCallbackIF,
   public RoleCallbackIF,
   public SDPProcessReportCallbackIF,
   public EnableAvpPauseCallbackIF
   // from org/bluez/Device1Proxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusDeviceCallbackIf() {}

   // HINT: these interfaces are called within context of thread defined in CcDbusIfAppLibrary.cma ("ccDbusIfThread")

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/Device1Proxy implementation --- start
   virtual void onConnectError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectError >& error) = 0;

   virtual void onConnectResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response) = 0;

   virtual void onDisconnectError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error) = 0;

   virtual void onDisconnectResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response) = 0;

   virtual void onPairError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairError >& error) = 0;

   virtual void onPairResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairResponse >& response) = 0;

   virtual void onCancelPairingError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelPairingError >& error) = 0;

   virtual void onCancelPairingResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelPairingResponse >& response) = 0;

   virtual void onDiscoverServicesError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DiscoverServicesError >& error) = 0;

   virtual void onDiscoverServicesResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< DiscoverServicesResponse >& response) = 0;

   virtual void onCancelDiscoveryError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelDiscoveryError >& error) = 0;

   virtual void onCancelDiscoveryResponse(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< CancelDiscoveryResponse >& response) = 0;

   virtual void onReportLinkkeyError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ReportLinkkeyError >& error) = 0;

   virtual void onReportLinkkeySignal(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ReportLinkkeySignal >& signal) = 0;

   virtual void onIncomingPairingCompError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IncomingPairingCompError >& error) = 0;

   virtual void onIncomingPairingCompSignal(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IncomingPairingCompSignal >& signal) = 0;

   virtual void onAddressError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AddressError >& error) = 0;

   virtual void onAddressUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AddressUpdate >& update) = 0;

   virtual void onClassError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ClassError >& error) = 0;

   virtual void onClassUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ClassUpdate >& update) = 0;

   virtual void onIconError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IconError >& error) = 0;

   virtual void onIconUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< IconUpdate >& update) = 0;

   virtual void onUUIDsError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< UUIDsError >& error) = 0;

   virtual void onUUIDsUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< UUIDsUpdate >& update) = 0;

   virtual void onPairedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairedError >& error) = 0;

   virtual void onPairedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PairedUpdate >& update) = 0;

   virtual void onConnectedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedError >& error) = 0;

   virtual void onConnectedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedUpdate >& update) = 0;

   virtual void onTrustedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< TrustedError >& error) = 0;

   virtual void onTrustedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< TrustedUpdate >& update) = 0;

   virtual void onBlockedError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< BlockedError >& error) = 0;

   virtual void onBlockedUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< BlockedUpdate >& update) = 0;

   virtual void onAliasError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AliasError >& error) = 0;

   virtual void onAliasUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AliasUpdate >& update) = 0;

   virtual void onAdapterError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AdapterError >& error) = 0;

   virtual void onAdapterUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< AdapterUpdate >& update) = 0;

   virtual void onModaliasError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModaliasError >& error) = 0;

   virtual void onModaliasUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModaliasUpdate >& update) = 0;

   virtual void onRSSIError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RSSIError >& error) = 0;

   virtual void onRSSIUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RSSIUpdate >& update) = 0;

   virtual void onVendorError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorError >& error) = 0;

   virtual void onVendorUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorUpdate >& update) = 0;

   virtual void onVendorSourceError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorSourceError >& error) = 0;

   virtual void onVendorSourceUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VendorSourceUpdate >& update) = 0;

   virtual void onProductError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ProductError >& error) = 0;

   virtual void onProductUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ProductUpdate >& update) = 0;

   virtual void onMapInfoError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< MapInfoError >& error) = 0;

   virtual void onMapInfoUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< MapInfoUpdate >& update) = 0;

   virtual void onConnectedServiceError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedServiceError >& error) = 0;

   virtual void onConnectedServiceUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedServiceUpdate >& update) = 0;

   virtual void onVersionError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VersionError >& error) = 0;

   virtual void onVersionUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< VersionUpdate >& update) = 0;

   virtual void onPBAPInfoError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PBAPInfoError >& error) = 0;

   virtual void onPBAPInfoUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< PBAPInfoUpdate >& update) = 0;

   virtual void onModeError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModeError >& error) = 0;

   virtual void onModeUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< ModeUpdate >& update) = 0;

   virtual void onRoleError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RoleError >& error) = 0;

   virtual void onRoleUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< RoleUpdate >& update) = 0;

   virtual void onSDPProcessReportError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< SDPProcessReportError >& error) = 0;

   virtual void onSDPProcessReportSignal(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< SDPProcessReportSignal >& signal) = 0;

   virtual void onEnableAvpPauseError(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< EnableAvpPauseError >& error) = 0;

   virtual void onEnableAvpPauseUpdate(const ::boost::shared_ptr< Device1Proxy >& proxy, const ::boost::shared_ptr< EnableAvpPauseUpdate >& update) = 0;
   // org/bluez/Device1Proxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_DEVICE_CALLBACK_IF_H_
