/**
 * @file IEvolutionGeniviDbusAgentManagerCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Callback Interface for AgentManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EvolutionGenivi DBUS callback for AgentManager.
 */

#ifndef _I_EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_CALLBACK_IF_H_
#define _I_EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_CALLBACK_IF_H_

#include "org/bluez/AgentManagerProxy.h"

using namespace ::org::bluez::AgentManager;
using namespace ::asf::core;

#include <string>

namespace ccdbusif {

/**
 * Callback interface class for AgentManager.
 */
class IEvolutionGeniviDbusAgentManagerCallbackIf :
   // from org/bluez/AgentManagerProxy.h --- start
   public RegisterAgentCallbackIF,
   public UnregisterAgentCallbackIF,
   public RequestDefaultAgentCallbackIF
   // from org/bluez/AgentManagerProxy.h --- end
{
public:
   /**
    * Destructor.
    */
   virtual ~IEvolutionGeniviDbusAgentManagerCallbackIf() {}

   // HINT: these interfaces are called within context of thread defined in CcDbusIfAppLibrary.cma ("ccDbusIfThread")

   // "ServiceAvailableIF" implementation --- start
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath) = 0;
   // "ServiceAvailableIF" implementation --- end

   // org/bluez/AgentManagerProxy implementation --- start
   virtual void onRegisterAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentError >& error) = 0;

   virtual void onRegisterAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentResponse >& response) = 0;

   virtual void onUnregisterAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentError >& error) = 0;

   virtual void onUnregisterAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentResponse >& response) = 0;

   virtual void onRequestDefaultAgentError(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RequestDefaultAgentError >& error) = 0;

   virtual void onRequestDefaultAgentResponse(const ::boost::shared_ptr< AgentManagerProxy >& proxy, const ::boost::shared_ptr< RequestDefaultAgentResponse >& response) = 0;
   // org/bluez/AgentManagerProxy implementation --- end
};

} //ccdbusif

#endif //_I_EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_CALLBACK_IF_H_
