/**
 * @file EvolutionGeniviUtility.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGeniviUtility.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGeniviUtility.
 */

#ifndef _EVOLUTION_GENIVI_UTILITY_H_
#define _EVOLUTION_GENIVI_UTILITY_H_

#include <string>
#include <vector>
#include <stdint.h>

#include "FwArray.h"

namespace ccdbusif {
namespace evolution_genivi_utility {

void convertBDAddress2ObjectPath(::std::string& objectPath, const ::fw::Array<unsigned char, 6>& bdAddress);
void convertBDAddress2ObjectPath(::std::string& objectPath, const ::std::vector<unsigned char>& bdAddress);
bool extractPbapData(unsigned short int& version, unsigned char& repositories, unsigned int& features, const ::std::string& data);
bool extractMapData(unsigned short int& version, unsigned char& instance, ::std::string& name, unsigned char& types, unsigned int& features, const ::std::string& data);
void writeInt8(::std::vector<unsigned char>& array, const int8_t data);
void writeUInt8(::std::vector<unsigned char>& array, const uint8_t data);
void writeInt16(::std::vector<unsigned char>& array, const int16_t data);
void writeUInt16(::std::vector<unsigned char>& array, const uint16_t data);
void writeInt32(::std::vector<unsigned char>& array, const int32_t data);
void writeUInt32(::std::vector<unsigned char>& array, const uint32_t data);
void writeInt64(::std::vector<unsigned char>& array, const int64_t data);
void writeUInt64(::std::vector<unsigned char>& array, const uint64_t data);
void writeString(::std::vector<unsigned char>& array, const ::std::string& data);
void writeArray(::std::vector<unsigned char>& array, const ::std::vector<unsigned char>& data);
void readUInt16(uint16_t& data, const ::std::vector<unsigned char>& array);

} //evolution_genivi_utility
} //ccdbusif

#endif //_EVOLUTION_GENIVI_UTILITY_H_
