/**
 * @file EvolutionGeniviDbusSppProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for Spp.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Spp.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_SPP_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_SPP_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEvolutionGeniviDbusSppSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/alps/evo/SPPProxy.h"

using namespace ::org::alps::evo::SPP;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusSppCallbackIf;

/**
 * Spp proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusSppProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEvolutionGeniviDbusSppSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusSppProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusSppProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusSppCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusSppProxyIf implementation --- start
   virtual act_t sendBtApplSppDataReqRequest(uint8 instance, const ::std::vector< uint8 >& data);

   virtual act_t sendBtApplSppSetUuidReqRequest(uint8 instance, const ::std::vector< uint8 >& data);

   virtual act_t sendBtApplSppFlowCtrlReqRequest(uint8 instance, uint8 action);
   // IEvolutionGeniviDbusSppProxyIf implementation --- end

protected:
   EvolutionGeniviDbusSppProxyIf();

private:
   ::boost::shared_ptr< SPPProxy > _sppProxy;
   IEvolutionGeniviDbusSppCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_SPP_PROXY_IF_H_
