/**
 * @file EvolutionGeniviDbusServiceProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for Service.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Service.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_SERVICE_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_SERVICE_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusServiceSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/bluez/ServiceProxy.h"

using namespace ::org::bluez::Service;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusServiceCallbackIf;

/**
 * Service proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusServiceProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusServiceSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusServiceProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusServiceProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusServiceCallbackIf* callbackIf, bool enableProxy);

   virtual void serviceCreated(const ::std::string& objPath);

   virtual void serviceRemoved(const ::std::string& objPath, const bool destroyDirectly = false);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // HINT: following interfaces are called within context of thread started in CcDbusIfController.cpp ("CC_DBUS_IF_THD")

   // IEvolutionGeniviDbusServiceProxyIf implementation --- start
   virtual act_t sendConnectRequest(const ::std::string& objPath);

   virtual act_t sendDisconnectRequest(const ::std::string& objPath);

   virtual act_t sendRemoteUUIDGet(const ::std::string& objPath);

   virtual act_t sendStateGet(const ::std::string& objPath);

   virtual act_t sendDeviceGet(const ::std::string& objPath);

   virtual act_t sendVersionGet(const ::std::string& objPath);
   // IEvolutionGeniviDbusServiceProxyIf implementation --- end

protected:
   EvolutionGeniviDbusServiceProxyIf();

private:
   ProxyManager< ServiceProxy > _serviceProxy;
   IEvolutionGeniviDbusServiceCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_SERVICE_PROXY_IF_H_
