/**
 * @file EvolutionGeniviDbusSerialProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS proxy for Serial.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Serial.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_SERIAL_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_SERIAL_PROXY_IF_H_

#include "ISetCallback.h"
#include "ICreateProxy.h"
#include "IDestroyProxy.h"
#include "IDestroyAllProxies.h"
#include "IEvolutionGeniviDbusSerialSendRequestIf.h"
#include "IEvolutionGeniviDbusSerialCallbackIf.h"
#include "IEvolutionGeniviDbusSerialTestProxyIf.h"
#include "DbusBaseProxyIf.h"

#include "asf/core/Proxy.h" // ServiceAvailableIF
#include "org/bluez/SerialProxy.h"

using namespace ::asf::core;
using namespace ::org::bluez::Serial;

namespace ccdbusif {
namespace evolution {

/**
 * Serial proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusSerialProxyIf :
   public ServiceAvailableIF,
   public ISetCallback< IEvolutionGeniviDbusSerialCallbackIf >,
   public ICreateProxy,
   public IDestroyProxy,
   public IDestroyAllProxies,
   public IEvolutionGeniviDbusSerialSendRequestIf,
   public SendDataCallbackIF,
   public SppDataIndCallbackIF,
   public FlowCtrlSendCallbackIF,
   public DeviceFilePathCallbackIF,
   public FlowCtrlRecvCallbackIF,
   public IEvolutionGeniviDbusSerialCallbackIf,
   public DbusBaseProxyIf< IEvolutionGeniviDbusSerialCallbackIf, SerialProxy, IEvolutionGeniviDbusSerialTestProxyIf >
{
public:
   EvolutionGeniviDbusSerialProxyIf(ICcDbusIfControllerClient* client);

   EvolutionGeniviDbusSerialProxyIf(ICcDbusIfControllerClient* client, IEvolutionGeniviDbusSerialTestProxyIf* testProxyIf);

   virtual ~EvolutionGeniviDbusSerialProxyIf();

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);

   virtual void onUnavailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   virtual void handleSetCallback(IEvolutionGeniviDbusSerialCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleCreateProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyAllProxies(void);

   virtual void handleDestroyAllRuntimeProxies(void);

   // IEvolutionGeniviDbusSerialSendRequestIf implementation --- start
   virtual IDestroyAllProxies* getDestroyer(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusSerialCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void createProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void destroyProxyIf(const unsigned int callbackId, const bool destroyDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual act_t sendSendDataRequest(const unsigned int callbackId, const ::std::string& objPath, const ::std::vector< uint8 >& data);

   virtual act_t sendFlowCtrlRecvGet(const unsigned int callbackId, const ::std::string& objPath);

   virtual void sendFlowCtrlRecvSet(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& flowCtrlRecv);
   // IEvolutionGeniviDbusSerialSendRequestIf implementation --- end

   // CallbackIF implementation --- start
   virtual void onSendDataError(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< SendDataError >& error);

   virtual void onSendDataResponse(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< SendDataResponse >& response);

   virtual void onSppDataIndError(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< SppDataIndError >& error);

   virtual void onSppDataIndSignal(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< SppDataIndSignal >& signal);

   virtual void onFlowCtrlSendError(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< FlowCtrlSendError >& error);

   virtual void onFlowCtrlSendSignal(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< FlowCtrlSendSignal >& signal);

   virtual void onDeviceFilePathError(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< DeviceFilePathError >& error);

   virtual void onDeviceFilePathSignal(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< DeviceFilePathSignal >& signal);

   virtual void onFlowCtrlRecvError(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< FlowCtrlRecvError >& error);

   virtual void onFlowCtrlRecvUpdate(const ::boost::shared_ptr< SerialProxy >& proxy, const ::boost::shared_ptr< FlowCtrlRecvUpdate >& update);
   // CallbackIF implementation --- end

   // IEvolutionGeniviDbusSerialCallbackIf implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onSendDataErrorCb(const ::boost::shared_ptr< SendDataError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSendDataResponseCb(const ::boost::shared_ptr< SendDataResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSppDataIndErrorCb(const ::boost::shared_ptr< SppDataIndError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSppDataIndSignalCb(const ::boost::shared_ptr< SppDataIndSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onFlowCtrlSendErrorCb(const ::boost::shared_ptr< FlowCtrlSendError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onFlowCtrlSendSignalCb(const ::boost::shared_ptr< FlowCtrlSendSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceFilePathErrorCb(const ::boost::shared_ptr< DeviceFilePathError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceFilePathSignalCb(const ::boost::shared_ptr< DeviceFilePathSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onFlowCtrlRecvErrorCb(const ::boost::shared_ptr< FlowCtrlRecvError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onFlowCtrlRecvUpdateCb(const ::boost::shared_ptr< FlowCtrlRecvUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
   // IEvolutionGeniviDbusSerialCallbackIf implementation --- end

protected:
   virtual void internalCreateProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyAllProxies(void);

   virtual void internalDestroyAllRuntimeProxies(void);

   void internalOnAvailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   void internalOnUnavailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_SERIAL_PROXY_IF_H_
