/**
 * @file EvolutionGeniviDbusPanProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for Pan.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Pan.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_PAN_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_PAN_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEvolutionGeniviDbusPanSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/alps/evo/PANProxy.h"

using namespace ::org::alps::evo::PAN;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusPanCallbackIf;

/**
 * Pan proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusPanProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEvolutionGeniviDbusPanSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusPanProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusPanProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusPanCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusPanProxyIf implementation --- start
   virtual act_t sendBtApplPanSendDataReqRequest(const ::std::vector< uint8 >& dest_addr, const ::std::vector< uint8 >& src_addr, uint16 pkt_type, const ::std::vector< uint8 >& data);

   virtual act_t sendBtApplPanFilterNettypeReqRequest(uint16 nettype_num, const ::std::vector< uint8 >& nettype_filter_list);

   virtual act_t sendBtApplPanFilterMuladdrReqRequest(uint16 addr_num, const ::std::vector< uint8 >& addr_filter_list);
   // IEvolutionGeniviDbusPanProxyIf implementation --- end

protected:
   EvolutionGeniviDbusPanProxyIf();

private:
   ::boost::shared_ptr< PANProxy > _panProxy;
   IEvolutionGeniviDbusPanCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_PAN_PROXY_IF_H_
