/**
 * @file EvolutionGeniviDbusObexTransferProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for ObexTransfer.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for ObexTransfer.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * ObexTransfer properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusObexTransferProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusObexTransferProperties();
   virtual ~EvolutionGeniviDbusObexTransferProperties();

   ObexTransferProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const ObexTransferProperty value) const;
   const ::std::string& getProperty2StringTrace(const ObexTransferProperty value) const;

private:
   const ::std::string _propertyStatus;
   const ::std::string _propertySession;
   const ::std::string _propertyName;
   const ::std::string _propertyType;
   const ::std::string _propertyTime;
   const ::std::string _propertySize;
   const ::std::string _propertyTransferred;
   const ::std::string _propertyFilename;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_OBEX_TRANSFER_PROPERTIES_H_
