/**
 * @file EvolutionGeniviDbusObexSessionProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for ObexSession.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for ObexSession.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_OBEX_SESSION_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_OBEX_SESSION_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusObexSessionSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/bluez/obex/SessionProxy.h"

using namespace ::org::bluez::obex::Session;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusObexSessionCallbackIf;

/**
 * ObexSession proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusObexSessionProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusObexSessionSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusObexSessionProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusObexSessionProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusObexSessionCallbackIf* callbackIf, bool enableProxy);

   virtual void sessionCreated(const ::std::string& objPath);

   virtual void sessionRemoved(const ::std::string& objPath);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // HINT: following interfaces are called within context of thread started in CcDbusIfController.cpp ("CC_DBUS_IF_THD")

   // IEvolutionGeniviDbusObexSessionProxyIf implementation --- start
   virtual act_t sendSourceGet(const ::std::string& objPath);

   virtual act_t sendDestinationGet(const ::std::string& objPath);

   virtual act_t sendChannelGet(const ::std::string& objPath);

   virtual act_t sendTargetGet(const ::std::string& objPath);
   // IEvolutionGeniviDbusObexSessionProxyIf implementation --- end

protected:
   EvolutionGeniviDbusObexSessionProxyIf();

private:
   ProxyManager< SessionProxy > _obexSessionProxy;
   IEvolutionGeniviDbusObexSessionCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_OBEX_SESSION_PROXY_IF_H_
