/**
 * @file EvolutionGeniviDbusObexClientProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for ObexClient.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for ObexClient.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * ObexClient properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusObexClientProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusObexClientProperties();
   virtual ~EvolutionGeniviDbusObexClientProperties();

   ObexClientArgsSuppValues getType2Enum(const ::std::string& value) const;
   const ::std::string& getType2String(const ObexClientArgsSuppValues value) const;

private:
   const std::string _argsMap;
   const std::string _argsPbap;
   const std::string _argsTarget;
   const std::string _argsSource;
   const std::string _argsChannel;
   const std::string _argsInstanceID;

   ::std::map< std::string, int > _args2EnumList; /**< map with supported value for Args + enum pairs */
   ::std::map< int, const std::string* > _enum2ArgsList; /**< map with enum + supported value for Args pairs */
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_OBEX_CLIENT_PROPERTIES_H_
