/**
 * @file EvolutionGeniviDbusLESeamlessPairingProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS proxy for LESeamlessPairing.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for LESeamlessPairing.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusLESeamlessPairingSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/bluez/SeamlessPairingProxy.h"

using namespace ::org::bluez::SeamlessPairing;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusLESeamlessPairingCallbackIf;

/**
 * LESeamlessPairing proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusLESeamlessPairingProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusLESeamlessPairingSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusLESeamlessPairingProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusLESeamlessPairingProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusLESeamlessPairingCallbackIf* callbackIf, bool enableProxy);

   virtual void seamlessPairingCreated(const ::std::string& objPath);

   virtual void seamlessPairingRemoved(const ::std::string& objPath);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusLESeamlessPairingProxyIf implementation --- start
   virtual act_t sendSendErrorCodeRequest(const ::std::string& objPath, const ::std::string& error_code);

   virtual act_t sendAllowAccessRequest(const ::std::string& objPath, bool accept);

   virtual act_t sendPairingDataGet(const ::std::string& objPath);

   virtual void sendPairingDataSet(const ::std::string& objPath, const ::std::vector< uint8 >& pairingData);
   // IEvolutionGeniviDbusLESeamlessPairingProxyIf implementation --- end

protected:
   EvolutionGeniviDbusLESeamlessPairingProxyIf();

private:
   ProxyManager< SeamlessPairingProxy > _lESeamlessPairingProxy;
   IEvolutionGeniviDbusLESeamlessPairingCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_PROXY_IF_H_
