/**
 * @file EvolutionGeniviDbusLESeamlessPairingProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for LESeamlessPairing.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for LESeamlessPairing.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * LESeamlessPairing properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusLESeamlessPairingProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusLESeamlessPairingProperties();
   virtual ~EvolutionGeniviDbusLESeamlessPairingProperties();

   LESeamlessPairingProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const LESeamlessPairingProperty value) const;
   const ::std::string& getProperty2StringTrace(const LESeamlessPairingProperty value) const;

private:
   const ::std::string _propertyPairingData;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_LE_SEAMLESS_PAIRING_PROPERTIES_H_
