/**
 * @file EvolutionGeniviDbusHfpVoiceCallProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpVoiceCall.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpVoiceCall.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpVoiceCallSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/ofono/VoiceCallProxy.h"

using namespace ::org::ofono::VoiceCall;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusHfpVoiceCallCallbackIf;

/**
 * HfpVoiceCall proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpVoiceCallProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpVoiceCallSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusHfpVoiceCallProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusHfpVoiceCallProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusHfpVoiceCallCallbackIf* callbackIf, bool enableProxy);

   virtual void callCreated(const ::std::string& objPath);

   virtual void callRemoved(const ::std::string& objPath);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusHfpVoiceCallProxyIf implementation --- start
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath);

   virtual act_t sendHangupRequest(const ::std::string& objPath);

   virtual act_t sendAnswerRequest(const ::std::string& objPath);

   virtual act_t sendHoldRequest(const ::std::string& objPath);
   // IEvolutionGeniviDbusHfpVoiceCallProxyIf implementation --- end

protected:
   EvolutionGeniviDbusHfpVoiceCallProxyIf();

private:
   ProxyManager< VoiceCallProxy > _hfpVoiceCallProxy;
   IEvolutionGeniviDbusHfpVoiceCallCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_PROXY_IF_H_
