/**
 * @file EvolutionGeniviDbusHfpVoiceCallProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for HfpVoiceCall.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for HfpVoiceCall.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpVoiceCall properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpVoiceCallProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusHfpVoiceCallProperties();
   virtual ~EvolutionGeniviDbusHfpVoiceCallProperties();

   HfpVoiceCallProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const HfpVoiceCallProperty value) const;
   const ::std::string& getProperty2StringTrace(const HfpVoiceCallProperty value) const;

private:
   const ::std::string _propertyLineIdentification;
   const ::std::string _propertyName;
   const ::std::string _propertyMultiparty;
   const ::std::string _propertyState;
   const ::std::string _propertyEmergency;
   const ::std::string _propertyDirection;
   const ::std::string _propertyMode;
   const ::std::string _propertyType;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_PROPERTIES_H_
