/**
 * @file EvolutionGeniviDbusHfpVoiceCallManagerProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for HfpVoiceCallManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for HfpVoiceCallManager.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpVoiceCallManager properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpVoiceCallManagerProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusHfpVoiceCallManagerProperties();
   virtual ~EvolutionGeniviDbusHfpVoiceCallManagerProperties();

   HfpVoiceCallManagerProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const HfpVoiceCallManagerProperty value) const;
   const ::std::string& getProperty2StringTrace(const HfpVoiceCallManagerProperty value) const;

private:
   const ::std::string _propertyEmergencyNumbers;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_VOICE_CALL_MANAGER_PROPERTIES_H_
