/**
 * @file EvolutionGeniviDbusHfpSiriProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpSiri.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpSiri.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_SIRI_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_SIRI_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpSiriSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/ofono/evo/SiriProxy.h"

using namespace ::org::ofono::evo::Siri;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusHfpSiriCallbackIf;

/**
 * HfpSiri proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpSiriProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpSiriSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusHfpSiriProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusHfpSiriProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusHfpSiriCallbackIf* callbackIf, bool enableProxy);

   virtual void deviceCreated(const ::std::string& objPath);

   virtual void deviceRemoved(const ::std::string& objPath);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusHfpSiriProxyIf implementation --- start
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath);

   virtual act_t sendEnableRequest(const ::std::string& objPath, uint16 vendor_id, uint16 product_id, uint16 version, uint16 support_type);

   virtual act_t sendSetNRRequest(const ::std::string& objPath, uint8 status);

   virtual act_t sendSetPropertyRequest(const ::std::string& objPath, const ::std::string& property, const bool value);
   // IEvolutionGeniviDbusHfpSiriProxyIf implementation --- end

protected:
   EvolutionGeniviDbusHfpSiriProxyIf();

private:
   ProxyManager< SiriProxy > _hfpSiriProxy;
   IEvolutionGeniviDbusHfpSiriCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_SIRI_PROXY_IF_H_
