/**
 * @file EvolutionGeniviDbusHfpNetworkRegistrationProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for HfpNetworkRegistration.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for HfpNetworkRegistration.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_NETWORK_REGISTRATION_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_NETWORK_REGISTRATION_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpNetworkRegistration properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpNetworkRegistrationProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusHfpNetworkRegistrationProperties();
   virtual ~EvolutionGeniviDbusHfpNetworkRegistrationProperties();

   HfpNetworkRegistrationProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const HfpNetworkRegistrationProperty value) const;
   const ::std::string& getProperty2StringTrace(const HfpNetworkRegistrationProperty value) const;

private:
   const ::std::string _propertyStatus;
   const ::std::string _propertyMobileCountryCode;
   const ::std::string _propertyName;
   const ::std::string _propertyStrength;
   const ::std::string _propertyCurrentOperator;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_NETWORK_REGISTRATION_PROPERTIES_H_
