/**
 * @file EvolutionGeniviDbusHfpNetworkOperatorProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpNetworkOperator.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpNetworkOperator.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpNetworkOperatorSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/ofono/NetworkOperatorProxy.h"

using namespace ::org::ofono::NetworkOperator;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusHfpNetworkOperatorCallbackIf;

/**
 * HfpNetworkOperator proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpNetworkOperatorProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpNetworkOperatorSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusHfpNetworkOperatorProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusHfpNetworkOperatorProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusHfpNetworkOperatorCallbackIf* callbackIf, bool enableProxy);

   virtual void operatorCreated(const ::std::string& objPath);

   virtual void operatorRemoved(const ::std::string& objPath);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusHfpNetworkOperatorProxyIf implementation --- start
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath);
   // IEvolutionGeniviDbusHfpNetworkOperatorProxyIf implementation --- end

protected:
   EvolutionGeniviDbusHfpNetworkOperatorProxyIf();

private:
   ProxyManager< NetworkOperatorProxy > _hfpNetworkOperatorProxy;
   IEvolutionGeniviDbusHfpNetworkOperatorCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_NETWORK_OPERATOR_PROXY_IF_H_
