/**
 * @file EvolutionGeniviDbusHfpModemProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpModem.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpModem.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_MODEM_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_MODEM_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpModemSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/ofono/ModemProxy.h"

using namespace ::org::ofono::Modem;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusHfpModemCallbackIf;

/**
 * HfpModem proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpModemProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpModemSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusHfpModemProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusHfpModemProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusHfpModemCallbackIf* callbackIf, bool enableProxy);

   virtual void modemCreated(const ::std::string& objPath);

   virtual void modemRemoved(const ::std::string& objPath, const bool destroyDirectly = false);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusHfpModemProxyIf implementation --- start
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath);

   virtual act_t sendSetPropertyRequest(const ::std::string& objPath, const ::std::string& property, const bool value);

   virtual act_t sendAcceptSCOConnectRequest(const ::std::string& objPath);
   // IEvolutionGeniviDbusHfpModemProxyIf implementation --- end

protected:
   EvolutionGeniviDbusHfpModemProxyIf();

private:
   ProxyManager< ModemProxy > _hfpModemProxy;
   IEvolutionGeniviDbusHfpModemCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_MODEM_PROXY_IF_H_
