/**
 * @file EvolutionGeniviDbusHfpModemProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for HfpModem.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for HfpModem.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_MODEM_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_MODEM_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpModem properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpModemProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusHfpModemProperties();
   virtual ~EvolutionGeniviDbusHfpModemProperties();

   HfpModemProperty getProperty2Enum(const ::std::string& value) const;
   HfpModemInterfaces getInterface2Enum(const ::std::string& value) const;
   HfpModemTypeSuppValues getType2Enum(const ::std::string& value) const;

   const ::std::string& getProperty2String(const HfpModemProperty value) const;
   const ::std::string& getProperty2StringTrace(const HfpModemProperty value) const;
   const ::std::string& getInterface2StringTrace(const HfpModemInterfaces value) const;
   const ::std::string& getType2StringTrace(const HfpModemTypeSuppValues value) const;

private:
   const ::std::string _propertyPowered;
   const ::std::string _propertyName;
   const ::std::string _propertyInterfaces;
   const ::std::string _propertyType;
   const ::std::string _propertyManufacturer;
   const ::std::string _propertyModel;
   const ::std::string _propertyRevision;
   const ::std::string _propertySerial;

   const ::std::string _interfaceOrgOfonoEvoSiri;
   const ::std::string _interfaceOrgOfonoVoiceCallManager;
   const ::std::string _interfaceOrgOfonoNetworkRegistration;
   const ::std::string _interfaceOrgOfonoHandsFree;
   const ::std::string _interfaceOrgOfonoCallVolume;

   const ::std::string _typeHfp;
   const ::std::string _typeSap;
   const ::std::string _typeHardware;

   ::std::map< std::string, int > _interface2EnumList; /**< map with supported value for Interfaces + enum pairs */
   ::std::map< int, const std::string* > _enum2InterfaceList; /**< map with enum + supported value for Interfaces pairs */

   ::std::map< std::string, int > _type2EnumList; /**< map with supported value for Type + enum pairs */
   ::std::map< int, const std::string* > _enum2TypeList; /**< map with enum + supported value for Type pairs */
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_MODEM_PROPERTIES_H_
