/**
 * @file EvolutionGeniviDbusHfpManagerProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpManager.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_MANAGER_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_MANAGER_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEvolutionGeniviDbusHfpManagerSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/ofono/ManagerProxy.h"

using namespace ::org::ofono::Manager;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusHfpManagerCallbackIf;

/**
 * HfpManager proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpManagerProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEvolutionGeniviDbusHfpManagerSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusHfpManagerProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusHfpManagerProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusHfpManagerCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusHfpManagerProxyIf implementation --- start
   virtual act_t sendGetModemsRequest(void);
   // IEvolutionGeniviDbusHfpManagerProxyIf implementation --- end

protected:
   EvolutionGeniviDbusHfpManagerProxyIf();

private:
   ::boost::shared_ptr< ManagerProxy > _hfpManagerProxy;
   IEvolutionGeniviDbusHfpManagerCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_MANAGER_PROXY_IF_H_
