/**
 * @file EvolutionGeniviDbusHfpHandsfreeProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for HfpHandsfree.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for HfpHandsfree.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpHandsfreeSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/ofono/HandsfreeProxy.h"

using namespace ::org::ofono::Handsfree;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusHfpHandsfreeCallbackIf;

/**
 * HfpHandsfree proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpHandsfreeProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpHandsfreeSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusHfpHandsfreeProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusHfpHandsfreeProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusHfpHandsfreeCallbackIf* callbackIf, bool enableProxy);

   virtual void deviceCreated(const ::std::string& objPath);

   virtual void deviceRemoved(const ::std::string& objPath, const bool destroyDirectly = false);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusHfpHandsfreeProxyIf implementation --- start
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath);

   virtual act_t sendSetPropertyRequest(const ::std::string& objPath, const ::std::string& property, const bool value);

   virtual act_t sendSetPropertyRequest(const ::std::string& objPath, const ::std::string& property, const ::std::string& value);

   virtual act_t sendRequestPhoneNumberRequest(const ::std::string& objPath);

   virtual act_t sendGetSubscriberRequest(const ::std::string& objPath);

   virtual act_t sendSendCustomATCommandRequest(const ::std::string& objPath, const ::std::vector< uint8 >& data);
   // IEvolutionGeniviDbusHfpHandsfreeProxyIf implementation --- end

protected:
   EvolutionGeniviDbusHfpHandsfreeProxyIf();

private:
   ProxyManager< HandsfreeProxy > _hfpHandsfreeProxy;
   IEvolutionGeniviDbusHfpHandsfreeCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_HFP_HANDSFREE_PROXY_IF_H_
