/**
 * @file EvolutionGeniviDbusGeniviTraceProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for GeniviTrace.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for GeniviTrace.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEvolutionGeniviDbusGeniviTraceSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/bluez/genivi/TraceProxy.h"

using namespace ::org::bluez::genivi::Trace;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusGeniviTraceCallbackIf;

/**
 * GeniviTrace proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusGeniviTraceProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEvolutionGeniviDbusGeniviTraceSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusGeniviTraceProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusGeniviTraceProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusGeniviTraceCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusGeniviTraceProxyIf implementation --- start
   // IEvolutionGeniviDbusGeniviTraceProxyIf implementation --- end

protected:
   EvolutionGeniviDbusGeniviTraceProxyIf();

private:
   ::boost::shared_ptr< TraceProxy > _geniviTraceProxy;
   IEvolutionGeniviDbusGeniviTraceCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_GENIVI_TRACE_PROXY_IF_H_
