/**
 * @file EvolutionGeniviDbusErrorCodes.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for ErrorCodes.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for ErrorCodes.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_ERROR_CODES_H_
#define _EVOLUTION_GENIVI_DBUS_ERROR_CODES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * ErrorCodes properties class for Evolution Genivi interface.
 */
class EvolutionGeniviDbusErrorCodes : public DbusProperties
{
public:
   EvolutionGeniviDbusErrorCodes();
   virtual ~EvolutionGeniviDbusErrorCodes();

   ErrorCode getErrorCode2Enum(const ::std::string& value) const;
   const ::std::string& getErrorCode2String(const ErrorCode value) const;
   const ::std::string& getErrorCode2StringTrace(const ErrorCode value) const;
   ErrorCode getErrorCode2Enum(const ::std::string& errorName, const ::std::string& errorMessage) const;

private:
   const size_t _workingStringCapacity; /**< working string capacity */
   ::std::string _workingString; /**< working string */

   // see HLI document, chapter "Status Codes"
   const ::std::string _org_bluez_Error_InvalidArguments; /**< Invalid arguments in method call. Please check parameter and resend the method call. */
   const ::std::string _org_bluez_Error_InProgress; /**< Operation already in progress. Please wait a moment and try again. */
   const ::std::string _org_bluez_Error_AlreadyExists; /**< Already Exists. Please check whether the object has been exist. */
   const ::std::string _org_bluez_Error_NotSupported; /**< Operation is not supported. Please check whether this operation can be done in this situation. */
   const ::std::string _org_bluez_Error_NotConnected; /**< Not Connected. Please check whether the service has not been connected. */
   const ::std::string _org_bluez_Error_AlreadyConnected; /**< Already Connected. Please check whether the service has already been connected. */
   const ::std::string _org_bluez_Error_NotAvailable; /**< Operation currently not available. Please check whether this operation can be done in this situation. */
   const ::std::string _org_bluez_Error_NotAuthorized; /**< Operation Not Authorized. Please check whether this operation can be done in this situation. */
   const ::std::string _org_bluez_Error_AgentNotAvailable; /**< Agent Not Available. Please check whether this Agent has been registered. */
   const ::std::string _org_bluez_Error_NotReady; /**< Resource Not Ready. Please wait a moment and try again. */
   const ::std::string _org_bluez_Error_Failed; /**< Operation failed. Please check the remote device state and try again. */
   const ::std::string _org_ofono_Error_InvalidArguments; /**< Invalid arguments in method call. Please check parameter and resend the method call. */
   const ::std::string _org_ofono_Error_InvalidFormat; /**< Argument format is not recognized. Please check parameter format and resend the method call. */
   const ::std::string _org_ofono_Error_NotImplemented; /**< Implementation not provided. Please check whether this operation is permitted. */
   const ::std::string _org_ofono_Error_Failed; /**< Operation failed. Please check the remote device state and try again. */
   const ::std::string _org_ofono_Error_InProgress; /**< Operation already in progress. Please wait a moment and try again. */
   const ::std::string _org_ofono_Error_NotFound; /**< Object is not found or not valid for this operation. Please check whether the object is exist and try again. */
   const ::std::string _org_ofono_Error_NotActive; /**< Operation is not active or in progress. Please wait a moment and try again. */
   const ::std::string _org_ofono_Error_NotSupported; /**< Operation is not supported by the network/modem. Please check whether this operation can be done in this situation. */
   const ::std::string _org_ofono_Error_NotAvailable; /**< Operation currently not available. Please check whether this operation can be done in this situation. */
   const ::std::string _org_ofono_Error_Timedout; /**< Operation failure due to timeout. Please check the remote device state and try again. */
   const ::std::string _org_ofono_Error_InUse; /**< The resource is currently in use. Please wait a moment and try again. */
   const ::std::string _org_bluez_obex_Error_InvalidArguments; /**< Invalid arguments in method call. Please check parameter and resend the method call. */
   const ::std::string _org_bluez_obex_Error_Failed; /**< Operation failed. Please check the remote device state and try again. */
   const ::std::string _org_bluez_obex_Error_Forbidden; /**< Operation is forbidden. Please check whether this operation is permitted. */
   const ::std::string _org_bluez_obex_NotAuthorized; /**< Operation Not Authorized. Please check whether this operation is permitted. */
   const ::std::string _org_bluez_obex_InProgress; /**< Operation already in progress. Please wait a moment and try again. */
   const ::std::string _org_bluez_obex_AlreadyConnected; /**< Already Connected. Please check whether the service has already been connected. */
   const ::std::string _org_bluez_Error_ConnectionLost; /**< Operation connection lost. Please check the environment and reconnect. */
   const ::std::string _org_bluez_Error_AuthenticationError; /**< Operation Authentication error. Please check the environment and try again. */
   const ::std::string _org_bluez_Error_PairingCancelled; /**< Operation pair cancelled. Please pair again. */
   const ::std::string _org_bluez_Error_MissingPINOrKey; /**< PIN or key is missing. Please check the environment and do the operation again. */
   const ::std::string _org_bluez_Error_UnknownReason; /**< Unknown Reason. */
   const ::std::string _org_bluez_Error_DoesNotExist; /**< E.g. action to be canceled does not exist. */
   const ::std::string _org_bluez_Error_DiscoverServicesCancelled; /**< Service discovery was cancelled. */
   const ::std::string _org_bluez_Error_ServiceIncoming; /**< Incoming remote connect ongoing. */
   const ::std::string _org_bluez_Error_ConnectionConflict; /**< Parallel local and remote connect (=> conflict). */

   const ::std::string _org_freedesktop_Error_UnknownObject; /**< org.freedesktop.DBus.Error.UnknownObject */
   const ::std::string _org_freedesktop_Error_UnknownMethod; /**< org.freedesktop.DBus.Error.UnknownMethod */
   const ::std::string _org_freedesktop_Error_NoServer; /**< org.freedesktop.DBus.Error.NoServer => reported by ASF after a DBUS service disappeared */
   const ::std::string _org_freedesktop_Error_NoReply; /**< org.freedesktop.DBus.Error.NoReply */

   const ::std::string _net_connman_Error_Failed; /**< net.connman.Error.Failed */
   const ::std::string _net_connman_Error_InvalidArguments; /**< net.connman.Error.InvalidArguments */
   const ::std::string _net_connman_Error_PermissionDenied; /**< net.connman.Error.PermissionDenied */
   const ::std::string _net_connman_Error_PassphraseRequired; /**< net.connman.Error.PassphraseRequired */
   const ::std::string _net_connman_Error_NotRegistered; /**< net.connman.Error.NotRegistered */
   const ::std::string _net_connman_Error_NotUnique; /**< net.connman.Error.NotUnique */
   const ::std::string _net_connman_Error_NotSupported; /**< net.connman.Error.NotSupported */
   const ::std::string _net_connman_Error_NotImplemented; /**< net.connman.Error.NotImplemented */
   const ::std::string _net_connman_Error_NotFound; /**< net.connman.Error.NotFound */
   const ::std::string _net_connman_Error_NoCarrier; /**< net.connman.Error.NoCarrier */
   const ::std::string _net_connman_Error_InProgress; /**< net.connman.Error.InProgress */
   const ::std::string _net_connman_Error_AlreadyExists; /**< net.connman.Error.AlreadyExists */
   const ::std::string _net_connman_Error_AlreadyEnabled; /**< net.connman.Error.AlreadyEnabled */
   const ::std::string _net_connman_Error_AlreadyDisabled; /**< net.connman.Error.AlreadyDisabled */
   const ::std::string _net_connman_Error_AlreadyConnected; /**< net.connman.Error.AlreadyConnected */
   const ::std::string _net_connman_Error_NotConnected; /**< net.connman.Error.NotConnected */
   const ::std::string _net_connman_Error_OperationAborted; /**< net.connman.Error.OperationAborted */
   const ::std::string _net_connman_Error_OperationTimeout; /**< net.connman.Error.OperationTimeout */
   const ::std::string _net_connman_Error_InvalidService; /**< net.connman.Error.InvalidService */
   const ::std::string _net_connman_Error_InvalidProperty; /**< net.connman.Error.InvalidProperty */

   // see HLI document, chapter "Extended Fail Error Result Codes"
   // sub-error codes
   const ::std::string _subErrorCode_UnknownOpcode; /**< OpCode is unknown or not supported. Please check command syntax and resend command. */
   const ::std::string _subErrorCode_IllegalFormat; /**< Message parameters are not in correct format. Please check parameter length and resend command. */
   const ::std::string _subErrorCode_IllegalParam; /**< Message parameter(s) are out of range. Please check parameter values and resend command. */
   const ::std::string _subErrorCode_OperationFail; /**< Operation failed. If failure is caused by remote Bluetooth device, In general no action will be required. */
   const ::std::string _subErrorCode_OperationFailed; /**< Operation failed. If failure is caused by remote Bluetooth device, In general no action will be required. */
   const ::std::string _subErrorCode_SystemBusy; /**< System is currently busy. Please wait a moment and try again. */
   const ::std::string _subErrorCode_IllegalOperation; /**< Operation cannot be carried out. Review host application and check whether the command can be executed in this situation. */
   const ::std::string _subErrorCode_IllegalState; /**< Operation cannot be carried out in the current state. Wait for appropriate state and try again. */
   const ::std::string _subErrorCode_SdpFailure; /**< Operation failed due to an SDP problem. Please check that the service is available in remote device, then issue re-connection attempt. */
   const ::std::string _subErrorCode_Abnormal; /**< Abnormal operation e.g. link loss causing disconnection. Please issue re-connection attempt if appropriate. */
   const ::std::string _subErrorCode_Aborted; /**< Operation has been aborted. In general no special action will be required. */
   const ::std::string _subErrorCode_ExtendedError; /**< Operation failed with Extended error. The action depends on the specific error code. */
   const ::std::string _subErrorCode_SdpConnectionError; /**< SDP Connection error. Please adjust the environment then try again. */
   const ::std::string _subErrorCode_TimeoutError; /**< Operation Timeout. In general no special action will be required. */
   const ::std::string _subErrorCode_RestrictedConnection; /**< Connection limitation error. When setup the outgoing connection which is not permit this error status will report to host. */
   const ::std::string _subErrorCode_RawDataIllegal; /**< Format of raw data sent from remote device is nonstandard. In general no special action will be required. */
   const ::std::string _subErrorCode_ServiceNotSupported; /**< Command is not supported. In general no special action will be required. */
   const ::std::string _subErrorCode_MoreDataExpected; /**< More packages are expected to be received from the Host. Please send remained packages. */
   const ::std::string _subErrorCode_SessionBusy; /**< Session is currently busy. Please wait a moment and try again. */
   const ::std::string _subErrorCode_PageTimeout; /**< HCI error code page timeout(0x04). Page time out in name request and connection request. Please check remote device status and try again. */
   const ::std::string _subErrorCode_RemoteReject; /**< Remote device reject FW outgoing connection. Please check remote device operation and try again. */
   const ::std::string _subErrorCode_LmpResponseTimeout; /**< HCI error code lmp response timeout(0x22). In general no special action will be required. */
   const ::std::string _subErrorCode_ConnectTimeout; /**< HCI error code connection timeout(0x08). In general no special action will be required. */
   const ::std::string _subErrorCode_AuthenticationFailure; /**< HCI error code authentication failure(0x05). Please initial pairing again. */
   const ::std::string _subErrorCode_RoleChangeNotAllowed; /**< HCI error code role change not allowed(0x21). In general no special action will be required. */
   const ::std::string _subErrorCode_ConnectRejectBdAddr; /**< HCI error code connection rejected due to unacceptable BD_ADDR (0x0F). In general no special action will be required. */
   const ::std::string _subErrorCode_AclExists; /**< HCI error code acl connection already exists(0x0B). Please check whether acl exist. */
   const ::std::string _subErrorCode_HwFailure; /**< HCI error code hardware failure(0x03). In general no special action will be required. */
   const ::std::string _subErrorCode_ConnectRejectLimitedResources; /**< HCI error code connection rejected due to limited resources(0x0D). Please check remote device connection information. */
   const ::std::string _subErrorCode_ConnectRejectSecurityReasons; /**< HCI error code connection rejected due to security reasons(0x0E). Please reset local and remote device security setting and try again. */
   const ::std::string _subErrorCode_RemoteDisconnectLowResource; /**< HCI error code remote device terminated connection due to low resources(0x14). In general no special action will be required. */
   const ::std::string _subErrorCode_RemoteDisconnectPowerOff; /**< HCI error code remote device terminated connection due to power off(0x15). In general no special action will be required. */
   const ::std::string _subErrorCode_PairingNotAllowed; /**< HCI error code remote device does not allow pairing(0x18). Please check the remote device configuration. */
   const ::std::string _subErrorCode_ConnectionAcceptTimeout; /**< HCI error code the Connection Accept Timeout has been exceeded for this connection attempt(0x10) Please check the remote device configuration. */
   const ::std::string _subErrorCode_LocalReject; /**< Module local reject command. In general no special action will be required. */
   const ::std::string _subErrorCode_InterfaceRemoved; /**< The interface has been removed. Please add the corresponding interface and try the operation again. */
   const ::std::string _subErrorCode_RemoteDisconnectAcl; /**< Remote device disconnects ACL directly during outgoing connection. */
   const ::std::string _subErrorCode_PsFailure; /**< PS failure */
   const ::std::string _subErrorCode_Empty; /**< no error code/message */

   const ::std::string& convert2Lower(const ::std::string& inputValue);
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_ERROR_CODES_H_
