/**
 * @file EvolutionGeniviDbusDunProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for Dun.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Dun.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_DUN_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_DUN_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEvolutionGeniviDbusDunSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/alps/evo/DUNProxy.h"

using namespace ::org::alps::evo::DUN;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusDunCallbackIf;

/**
 * Dun proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusDunProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEvolutionGeniviDbusDunSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusDunProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusDunProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusDunCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusDunProxyIf implementation --- start
   virtual act_t sendBtApplDunSendDataReqRequest(const ::std::vector< uint8 >& data);

   virtual act_t sendBtApplDunFlowCtrlReqRequest(uint8 action);
   // IEvolutionGeniviDbusDunProxyIf implementation --- end

protected:
   EvolutionGeniviDbusDunProxyIf();

private:
   ::boost::shared_ptr< DUNProxy > _dunProxy;
   IEvolutionGeniviDbusDunCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_DUN_PROXY_IF_H_
