/**
 * @file EvolutionGeniviDbusDidProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for Did.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Did.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_DID_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_DID_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEvolutionGeniviDbusDidSendRequestIf.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/alps/evo/DIDProxy.h"

using namespace ::org::alps::evo::DID;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusDidCallbackIf;

/**
 * Did proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusDidProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEvolutionGeniviDbusDidSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusDidProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusDidProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusDidCallbackIf* callbackIf, bool enableProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEvolutionGeniviDbusDidProxyIf implementation --- start
   virtual act_t sendBtApplDidSetReqRequest(uint8 entry, const ::std::vector< uint8 >& record);
   // IEvolutionGeniviDbusDidProxyIf implementation --- end

protected:
   EvolutionGeniviDbusDidProxyIf();

private:
   ::boost::shared_ptr< DIDProxy > _didProxy;
   IEvolutionGeniviDbusDidCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_DID_PROXY_IF_H_
