/**
 * @file EvolutionGeniviDbusDeviceProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Proxy for Device.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Device.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_DEVICE_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_DEVICE_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusDeviceSendRequestIf.h"
#include "ProxyManager.h"
#include "BaseDbusProxyIf.h"

#include "asf/core/Proxy.h"

#include "org/bluez/Device1Proxy.h"

using namespace ::org::bluez::Device1;
using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEvolutionGeniviDbusDeviceCallbackIf;

/**
 * Device proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusDeviceProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public ICcDbusIfCreateRuntimeProxy,
   public ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusDeviceSendRequestIf,
   public BaseDbusProxyIf
{
public:
   EvolutionGeniviDbusDeviceProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EvolutionGeniviDbusDeviceProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void createRuntimeProxy(const ::std::string& objPath);

   virtual void destroyRuntimeProxy(const ::std::string& objPath);

   virtual void setCallbackIf(IEvolutionGeniviDbusDeviceCallbackIf* callbackIf, bool enableProxy);

   virtual void deviceCreated(const ::std::string& objPath);

   virtual void deviceRemoved(const ::std::string& objPath, const bool destroyDirectly = false);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // HINT: following interfaces are called within context of thread started in CcDbusIfController.cpp ("CC_DBUS_IF_THD")

   // IEvolutionGeniviDbusDeviceProxyIf implementation --- start
   virtual act_t sendConnectRequest(const ::std::string& objPath);

   virtual act_t sendDisconnectRequest(const ::std::string& objPath);

   virtual act_t sendPairRequest(const ::std::string& objPath);

   virtual act_t sendCancelPairingRequest(const ::std::string& objPath);

   virtual act_t sendDiscoverServicesRequest(const ::std::string& objPath, const ::std::string& pattern);

   virtual act_t sendCancelDiscoveryRequest(const ::std::string& objPath);

   virtual act_t sendAddressGet(const ::std::string& objPath);

   virtual act_t sendClassGet(const ::std::string& objPath);

   virtual act_t sendIconGet(const ::std::string& objPath);

   virtual act_t sendUUIDsGet(const ::std::string& objPath);

   virtual act_t sendPairedGet(const ::std::string& objPath);

   virtual act_t sendConnectedGet(const ::std::string& objPath);

   virtual act_t sendTrustedGet(const ::std::string& objPath);

   virtual void sendTrustedSet(const ::std::string& objPath, bool trusted);

   virtual act_t sendBlockedGet(const ::std::string& objPath);

   virtual void sendBlockedSet(const ::std::string& objPath, bool blocked);

   virtual act_t sendAliasGet(const ::std::string& objPath);

   virtual void sendAliasSet(const ::std::string& objPath, const ::std::string& alias);

   virtual act_t sendAdapterGet(const ::std::string& objPath);

   virtual act_t sendModaliasGet(const ::std::string& objPath);

   virtual act_t sendRSSIGet(const ::std::string& objPath);

   virtual act_t sendVendorGet(const ::std::string& objPath);

   virtual act_t sendVendorSourceGet(const ::std::string& objPath);

   virtual act_t sendProductGet(const ::std::string& objPath);

   virtual act_t sendMapInfoGet(const ::std::string& objPath);

   virtual act_t sendConnectedServiceGet(const ::std::string& objPath);

   virtual act_t sendVersionGet(const ::std::string& objPath);

   virtual act_t sendPBAPInfoGet(const ::std::string& objPath);

   virtual act_t sendModeGet(const ::std::string& objPath);

   virtual act_t sendRoleGet(const ::std::string& objPath);

   virtual act_t sendEnableAvpPauseGet(const ::std::string& objPath);

   virtual void sendEnableAvpPauseSet(const ::std::string& objPath, bool enableAvpPause);
   // IEvolutionGeniviDbusDeviceProxyIf implementation --- end

protected:
   EvolutionGeniviDbusDeviceProxyIf();

private:
   ProxyManager< Device1Proxy > _deviceProxy;
   IEvolutionGeniviDbusDeviceCallbackIf* _callbackIf;
};

} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_DEVICE_PROXY_IF_H_
