/**
 * @file EvolutionGeniviDbusDeviceProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for Device.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for Device.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_DEVICE_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_DEVICE_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * Device properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusDeviceProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusDeviceProperties();
   virtual ~EvolutionGeniviDbusDeviceProperties();

   DeviceProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const DeviceProperty value) const;
   const ::std::string& getProperty2StringTrace(const DeviceProperty value) const;

private:
   const ::std::string _propertyAddress;
   const ::std::string _propertyClass;
   const ::std::string _propertyIcon;
   const ::std::string _propertyUUIDs;
   const ::std::string _propertyPaired;
   const ::std::string _propertyConnected;
   const ::std::string _propertyTrusted;
   const ::std::string _propertyBlocked;
   const ::std::string _propertyAlias;
   const ::std::string _propertyAdapter;
   const ::std::string _propertyModalias;
   const ::std::string _propertyRSSI;
   const ::std::string _propertyVendor;
   const ::std::string _propertyVendorSource;
   const ::std::string _propertyProduct;
   const ::std::string _propertyMapInfo;
   const ::std::string _propertyConnectedService;
   const ::std::string _propertyVersion;
   const ::std::string _propertyPBAPInfo;
   const ::std::string _propertyMode;
   const ::std::string _propertyRole;
   const ::std::string _propertyEnableAvpPause;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_DEVICE_PROPERTIES_H_
