/**
 * @file EvolutionGeniviDbusComponents.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for Components.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for Components.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_COMPONENTS_H_
#define _EVOLUTION_GENIVI_DBUS_COMPONENTS_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * Components properties class for Evolution Genivi interface.
 */
class EvolutionGeniviDbusComponents : public DbusProperties
{
public:
   EvolutionGeniviDbusComponents();
   virtual ~EvolutionGeniviDbusComponents();

   Interface getInterface2Enum(const ::std::string& value) const;
   const ::std::string& getInterface2String(const Interface value) const;
   const ::std::string& getInterface2StringTrace(const Interface value) const;

   DbusBusType getInterface2BusType(const Interface value) const;
   const ::std::string& getInterface2BusName(const Interface value) const;
   const ::std::string& getInterface2ObjectPath(const Interface value) const;
   inline const ::std::string& getRootObjectPath(void) const { return _objPathRoot; }
   const ::std::string& getInterface2Port(const Interface value) const;

   inline DbusBusType getAgentBusType(void) const { return _busTypeAgent; }
   inline const ::std::string& getAgentBusName(void) const { return _busNameAgent; }
   inline const ::std::string& getAgentObjectPath(void) const { return _objPathAgent; }

private:
   // see HLI document, chapter "D-Bus Interface"
   const ::std::string _interfaceAdapter;
   const ::std::string _interfaceAgentManager;
   const ::std::string _interfaceDevice;
   const ::std::string _interfaceService;
   const ::std::string _interfaceTrace;
   const ::std::string _interfaceGeniviTrace;
   const ::std::string _interfaceDM;
   const ::std::string _interfaceSPP;
   const ::std::string _interfaceDID;
   const ::std::string _interfaceDUN;
   const ::std::string _interfacePAN;
   const ::std::string _interfaceHandsfree;
   const ::std::string _interfaceManager;
   const ::std::string _interfaceModem;
   const ::std::string _interfaceVoiceCall;
   const ::std::string _interfaceVoiceCallManager;
   const ::std::string _interfaceNetworkRegistration;
   const ::std::string _interfaceNetworkOperator;
   const ::std::string _interfaceCallVolume;
   const ::std::string _interfaceSiri;
   const ::std::string _interfaceAVP;
   const ::std::string _interfaceMediaFolder;
   const ::std::string _interfaceMediaItem;
   const ::std::string _interfaceMediaPlayer;
   const ::std::string _interfaceMediaTransport;
   const ::std::string _interfaceClient;
   const ::std::string _interfacePhonebookAccess;
   const ::std::string _interfaceSession;
   const ::std::string _interfaceTransfer;
   const ::std::string _interfaceMessage;
   const ::std::string _interfaceMessageAccess;
   const ::std::string _interfaceNetwork;
   const ::std::string _interfaceSerial;
   const ::std::string _interfaceLEAdapter;
   const ::std::string _interfaceLEDevice;
   const ::std::string _interfaceLESeamlessPairing;

   const DbusBusType _busTypeSystem;
   const DbusBusType _busTypeSession;

   const ::std::string _busName_org_bluez;
   const ::std::string _busName_org_ofono;
   const ::std::string _busName_org_bluez_obex;
   const ::std::string _busName_org_alps_evolution;

   const ::std::string _objPathAdapter;
   const ::std::string _objPathAgentManager;
   const ::std::string _objPathDevice;
   const ::std::string _objPathService;
   const ::std::string _objPathTrace;
   const ::std::string _objPathGeniviTrace;
   const ::std::string _objPathDM;
   const ::std::string _objPathSPP;
   const ::std::string _objPathDID;
   const ::std::string _objPathDUN;
   const ::std::string _objPathPAN;
   const ::std::string _objPathHandsfree;
   const ::std::string _objPathManager;
   const ::std::string _objPathModem;
   const ::std::string _objPathVoiceCall;
   const ::std::string _objPathVoiceCallManager;
   const ::std::string _objPathNetworkRegistration;
   const ::std::string _objPathNetworkOperator;
   const ::std::string _objPathCallVolume;
   const ::std::string _objPathSiri;
   const ::std::string _objPathAVP;
   const ::std::string _objPathMediaFolder;
   const ::std::string _objPathMediaItem;
   const ::std::string _objPathMediaPlayer;
   const ::std::string _objPathMediaTransport;
   const ::std::string _objPathClient;
   const ::std::string _objPathPhonebookAccess;
   const ::std::string _objPathSession;
   const ::std::string _objPathTransfer;
   const ::std::string _objPathMessage;
   const ::std::string _objPathMessageAccess;
   const ::std::string _objPathNetwork;
   const ::std::string _objPathSerial;
   const ::std::string _objPathLEAdapter;
   const ::std::string _objPathLEDevice;
   const ::std::string _objPathLESeamlessPairing;

   const ::std::string _objPathRoot;
   const DbusBusType _busTypeAgent;
   const ::std::string _busNameAgent;
   const ::std::string _objPathAgent;

   const ::std::string _evoAdapterPort;
   const ::std::string _evoAgentManagerPort;
   const ::std::string _evoDevicePort;
   const ::std::string _evoServicePort;
   const ::std::string _evoTracePort;
   const ::std::string _evoGeniviTracePort;
   const ::std::string _evoDMPort;
   const ::std::string _evoSPPPort;
   const ::std::string _evoDIDPort;
   const ::std::string _evoDUNPort;
   const ::std::string _evoPANPort;
   const ::std::string _evoHandsfreePort;
   const ::std::string _evoManagerPort;
   const ::std::string _evoModemPort;
   const ::std::string _evoVoiceCallPort;
   const ::std::string _evoVoiceCallManagerPort;
   const ::std::string _evoNetworkRegistrationPort;
   const ::std::string _evoNetworkOperatorPort;
   const ::std::string _evoCallVolumePort;
   const ::std::string _evoSiriPort;
   const ::std::string _evoAVPPort;
   const ::std::string _evoMediaFolderPort;
   const ::std::string _evoMediaItemPort;
   const ::std::string _evoMediaPlayerPort;
   const ::std::string _evoMediaTransportPort;
   const ::std::string _evoClientPort;
   const ::std::string _evoPhonebookAccessPort;
   const ::std::string _evoSessionPort;
   const ::std::string _evoTransferPort;
   const ::std::string _evoMessagePort;
   const ::std::string _evoMessageAccessPort;
   const ::std::string _evoNetworkPort;
   const ::std::string _evoSerialPort;
   const ::std::string _evoLEAdapterPort;
   const ::std::string _evoLEDevicePort;
   const ::std::string _evoLESeamlessPairingPort;

   DbusBusType _interface2BusType[IF_UNKNOWN];
   const std::string* _interface2BusName[IF_UNKNOWN];
   const std::string* _interface2ObjectPath[IF_UNKNOWN];
   const std::string* _interface2Port[IF_UNKNOWN];
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_COMPONENTS_H_
