/**
 * @file EvolutionGeniviDbusAgentServer.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS stub for Agent.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS stub for Agent.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_AGENT_SERVER_H_
#define _EVOLUTION_GENIVI_DBUS_AGENT_SERVER_H_

#include "org/bluez/AgentStub.h"

using namespace ::org::bluez::Agent;

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusAgentCallbackIf;

namespace evolution {

/**
 * Agent stub class for EvolutionGenivi interface (to provide "createProxy functionality").
 */
class EvolutionGeniviDbusAgentServer :
   public AgentStub
{
public:
   EvolutionGeniviDbusAgentServer(IEvolutionGeniviDbusAgentCallbackIf* callbackIf);
   virtual ~EvolutionGeniviDbusAgentServer();

   // AgentStub implementation --- start
   virtual void onReleaseRequest(const ::boost::shared_ptr< ReleaseRequest >& request);

   virtual void onRequestPinCodeRequest(const ::boost::shared_ptr< RequestPinCodeRequest >& request);

   virtual void onDisplayPinCodeRequest(const ::boost::shared_ptr< DisplayPinCodeRequest >& request);

   virtual void onRequestPasskeyRequest(const ::boost::shared_ptr< RequestPasskeyRequest >& request);

   virtual void onRequestConfirmationRequest(const ::boost::shared_ptr< RequestConfirmationRequest >& request);

   virtual void onCancelRequest(const ::boost::shared_ptr< CancelRequest >& request);

   virtual void onCancelRequestRequest(const ::boost::shared_ptr< CancelRequestRequest >& request);

   virtual void onAuthorizeServiceRequest(const ::boost::shared_ptr< AuthorizeServiceRequest >& request);

   virtual void onRequestAuthorizationRequest(const ::boost::shared_ptr< RequestAuthorizationRequest >& request);

   virtual void onRequestLinkkeyRequest(const ::boost::shared_ptr< RequestLinkkeyRequest >& request);

   virtual void onDisplayPasskeyRequest(const ::boost::shared_ptr< DisplayPasskeyRequest >& request);
   // AgentStub implementation --- end

protected:
   EvolutionGeniviDbusAgentServer();

private:
   IEvolutionGeniviDbusAgentCallbackIf* _callbackIf;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_AGENT_SERVER_H_
