/**
 * @file EvolutionGeniviDbusAgentManagerProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for AgentManager.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for AgentManager.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * AgentManager properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusAgentManagerProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusAgentManagerProperties();
   virtual ~EvolutionGeniviDbusAgentManagerProperties();

   AgentManagerCapabilitySuppValues getCapability2Enum(const ::std::string& value) const;
   const ::std::string& getCapability2String(const AgentManagerCapabilitySuppValues value) const;

private:
   const std::string _capabilityDisplayOnly;
   const std::string _capabilityDisplayYesNo;
   const std::string _capabilityKeyboardOnly;
   const std::string _capabilityNoInputNoOutput;
   const std::string _capabilityKeyboardDisplay;

   ::std::map< std::string, int > _capability2EnumList; /**< map with supported value for capabilities + enum pairs */
   ::std::map< int, const std::string* > _enum2capabilityList; /**< map with enum + supported value for capabilities pairs */
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_AGENT_MANAGER_PROPERTIES_H_
