/**
 * @file EvolutionGeniviDbusAdapterProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS proxy for Adapter.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS proxy for Adapter.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_ADAPTER_PROXY_IF_H_
#define _EVOLUTION_GENIVI_DBUS_ADAPTER_PROXY_IF_H_

#include "ISetCallback.h"
#include "ICreateProxy.h"
#include "IDestroyProxy.h"
#include "IDestroyAllProxies.h"
#include "IEvolutionGeniviDbusAdapterSendRequestIf.h"
#include "IEvolutionGeniviDbusAdapterCallbackIf.h"
#include "IEvolutionGeniviDbusAdapterTestProxyIf.h"
#include "DbusBaseProxyIf.h"

#include "asf/core/Proxy.h" // ServiceAvailableIF
#include "org/bluez/Adapter1Proxy.h"

using namespace ::asf::core;
using namespace ::org::bluez::Adapter1;

namespace ccdbusif {
namespace evolution {

/**
 * Adapter proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusAdapterProxyIf :
   public ServiceAvailableIF,
   public ISetCallback< IEvolutionGeniviDbusAdapterCallbackIf >,
   public ICreateProxy,
   public IDestroyProxy,
   public IDestroyAllProxies,
   public IEvolutionGeniviDbusAdapterSendRequestIf,
   public StartDiscoveryCallbackIF,
   public StopDiscoveryCallbackIF,
   public RemoveDeviceCallbackIF,
   public CreateDeviceCallbackIF,
   public SendHCICmdCallbackIF,
   public AdapterInitializationCallbackIF,
   public DeviceCreatedCallbackIF,
   public DeviceRemovedCallbackIF,
   public BtStackLogCallbackIF,
   public HCIEventCallbackIF,
   public DeviceFoundCallbackIF,
   public AddressCallbackIF,
   public ClassCallbackIF,
   public AliasCallbackIF,
   public PoweredCallbackIF,
   public DiscoverableCallbackIF,
   public DiscoverableTimeoutCallbackIF,
   public PairableCallbackIF,
   public PairableTimeoutCallbackIF,
   public DiscoveringCallbackIF,
   public UUIDsCallbackIF,
   public WBSModeCallbackIF,
   public ConnectableCallbackIF,
   public HCIModeCallbackIF,
   public VersionCallbackIF,
   public TraceLevelCallbackIF,
   public TraceCategoryCallbackIF,
   public AvailableSPPServersCallbackIF,
   public IEvolutionGeniviDbusAdapterCallbackIf,
   public DbusBaseProxyIf< IEvolutionGeniviDbusAdapterCallbackIf, Adapter1Proxy, IEvolutionGeniviDbusAdapterTestProxyIf >
{
public:
   EvolutionGeniviDbusAdapterProxyIf(ICcDbusIfControllerClient* client);

   EvolutionGeniviDbusAdapterProxyIf(ICcDbusIfControllerClient* client, IEvolutionGeniviDbusAdapterTestProxyIf* testProxyIf);

   virtual ~EvolutionGeniviDbusAdapterProxyIf();

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);

   virtual void onUnavailable(const boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   virtual void handleSetCallback(IEvolutionGeniviDbusAdapterCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleCreateProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyProxy(const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void handleDestroyAllProxies(void);

   virtual void handleDestroyAllRuntimeProxies(void);

   // IEvolutionGeniviDbusAdapterSendRequestIf implementation --- start
   virtual IDestroyAllProxies* getDestroyer(void);

   virtual void setCallbackIf(IEvolutionGeniviDbusAdapterCallbackIf* callbackIf, const bool enableProxy, const unsigned int callbackId, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void createProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void destroyProxyIf(const unsigned int callbackId, const bool createDirectly = false, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual act_t sendStartDiscoveryRequest(const unsigned int callbackId);

   virtual act_t sendStopDiscoveryRequest(const unsigned int callbackId);

   virtual act_t sendRemoveDeviceRequest(const unsigned int callbackId, const ::std::string& device);

   virtual act_t sendCreateDeviceRequest(const unsigned int callbackId, const ::std::string& address);

   virtual act_t sendSendHCICmdRequest(const unsigned int callbackId, const ::std::vector< uint8 >& data);

   virtual act_t sendAddressGet(const unsigned int callbackId);

   virtual act_t sendClassGet(const unsigned int callbackId);

   virtual act_t sendAliasGet(const unsigned int callbackId);

   virtual void sendAliasSet(const unsigned int callbackId, const ::std::string& alias);

   virtual act_t sendPoweredGet(const unsigned int callbackId);

   virtual void sendPoweredSet(const unsigned int callbackId, bool powered);

   virtual act_t sendDiscoverableGet(const unsigned int callbackId);

   virtual void sendDiscoverableSet(const unsigned int callbackId, bool discoverable);

   virtual act_t sendDiscoverableTimeoutGet(const unsigned int callbackId);

   virtual void sendDiscoverableTimeoutSet(const unsigned int callbackId, uint32 discoverableTimeout);

   virtual act_t sendPairableGet(const unsigned int callbackId);

   virtual void sendPairableSet(const unsigned int callbackId, bool pairable);

   virtual act_t sendPairableTimeoutGet(const unsigned int callbackId);

   virtual void sendPairableTimeoutSet(const unsigned int callbackId, uint32 pairableTimeout);

   virtual act_t sendDiscoveringGet(const unsigned int callbackId);

   virtual act_t sendUUIDsGet(const unsigned int callbackId);

   virtual void sendUUIDsSet(const unsigned int callbackId, const ::std::vector< ::std::string >& uUIDs);

   virtual act_t sendWBSModeGet(const unsigned int callbackId);

   virtual void sendWBSModeSet(const unsigned int callbackId, bool wBSMode);

   virtual act_t sendConnectableGet(const unsigned int callbackId);

   virtual void sendConnectableSet(const unsigned int callbackId, bool connectable);

   virtual act_t sendHCIModeGet(const unsigned int callbackId);

   virtual void sendHCIModeSet(const unsigned int callbackId, bool hCIMode);

   virtual act_t sendVersionGet(const unsigned int callbackId);

   virtual act_t sendTraceLevelGet(const unsigned int callbackId);

   virtual void sendTraceLevelSet(const unsigned int callbackId, const ::std::vector< ::std::string >& traceLevel);

   virtual act_t sendTraceCategoryGet(const unsigned int callbackId);

   virtual void sendTraceCategorySet(const unsigned int callbackId, const ::std::vector< ::std::string >& traceCategory);

   virtual act_t sendAvailableSPPServersGet(const unsigned int callbackId);

   virtual void sendAvailableSPPServersSet(const unsigned int callbackId, const ::std::vector< ::std::string >& availableSPPServers);
   // IEvolutionGeniviDbusAdapterSendRequestIf implementation --- end

   // CallbackIF implementation --- start
   virtual void onStartDiscoveryError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< StartDiscoveryError >& error);

   virtual void onStartDiscoveryResponse(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< StartDiscoveryResponse >& response);

   virtual void onStopDiscoveryError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< StopDiscoveryError >& error);

   virtual void onStopDiscoveryResponse(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< StopDiscoveryResponse >& response);

   virtual void onRemoveDeviceError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< RemoveDeviceError >& error);

   virtual void onRemoveDeviceResponse(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< RemoveDeviceResponse >& response);

   virtual void onCreateDeviceError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< CreateDeviceError >& error);

   virtual void onCreateDeviceResponse(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< CreateDeviceResponse >& response);

   virtual void onSendHCICmdError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< SendHCICmdError >& error);

   virtual void onSendHCICmdResponse(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< SendHCICmdResponse >& response);

   virtual void onAdapterInitializationError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdapterInitializationError >& error);

   virtual void onAdapterInitializationSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdapterInitializationSignal >& signal);

   virtual void onDeviceCreatedError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceCreatedError >& error);

   virtual void onDeviceCreatedSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceCreatedSignal >& signal);

   virtual void onDeviceRemovedError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceRemovedError >& error);

   virtual void onDeviceRemovedSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceRemovedSignal >& signal);

   virtual void onBtStackLogError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< BtStackLogError >& error);

   virtual void onBtStackLogSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< BtStackLogSignal >& signal);

   virtual void onHCIEventError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< HCIEventError >& error);

   virtual void onHCIEventSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< HCIEventSignal >& signal);

   virtual void onDeviceFoundError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceFoundError >& error);

   virtual void onDeviceFoundSignal(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DeviceFoundSignal >& signal);

   virtual void onAddressError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressError >& error);

   virtual void onAddressUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressUpdate >& update);

   virtual void onClassError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< ClassError >& error);

   virtual void onClassUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< ClassUpdate >& update);

   virtual void onAliasError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AliasError >& error);

   virtual void onAliasUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AliasUpdate >& update);

   virtual void onPoweredError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PoweredError >& error);

   virtual void onPoweredUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PoweredUpdate >& update);

   virtual void onDiscoverableError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableError >& error);

   virtual void onDiscoverableUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableUpdate >& update);

   virtual void onDiscoverableTimeoutError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableTimeoutError >& error);

   virtual void onDiscoverableTimeoutUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableTimeoutUpdate >& update);

   virtual void onPairableError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PairableError >& error);

   virtual void onPairableUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PairableUpdate >& update);

   virtual void onPairableTimeoutError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PairableTimeoutError >& error);

   virtual void onPairableTimeoutUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< PairableTimeoutUpdate >& update);

   virtual void onDiscoveringError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoveringError >& error);

   virtual void onDiscoveringUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoveringUpdate >& update);

   virtual void onUUIDsError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< UUIDsError >& error);

   virtual void onUUIDsUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< UUIDsUpdate >& update);

   virtual void onWBSModeError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< WBSModeError >& error);

   virtual void onWBSModeUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< WBSModeUpdate >& update);

   virtual void onConnectableError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< ConnectableError >& error);

   virtual void onConnectableUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< ConnectableUpdate >& update);

   virtual void onHCIModeError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< HCIModeError >& error);

   virtual void onHCIModeUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< HCIModeUpdate >& update);

   virtual void onVersionError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< VersionError >& error);

   virtual void onVersionUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< VersionUpdate >& update);

   virtual void onTraceLevelError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< TraceLevelError >& error);

   virtual void onTraceLevelUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< TraceLevelUpdate >& update);

   virtual void onTraceCategoryError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< TraceCategoryError >& error);

   virtual void onTraceCategoryUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< TraceCategoryUpdate >& update);

   virtual void onAvailableSPPServersError(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AvailableSPPServersError >& error);

   virtual void onAvailableSPPServersUpdate(const ::boost::shared_ptr< Adapter1Proxy >& proxy, const ::boost::shared_ptr< AvailableSPPServersUpdate >& update);
   // CallbackIF implementation --- end

   // IEvolutionGeniviDbusAdapterCallbackIf implementation --- start
   virtual void onAvailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onUnavailableCb(const bool available, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM);

   virtual void onStartDiscoveryErrorCb(const ::boost::shared_ptr< StartDiscoveryError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onStartDiscoveryResponseCb(const ::boost::shared_ptr< StartDiscoveryResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onStopDiscoveryErrorCb(const ::boost::shared_ptr< StopDiscoveryError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onStopDiscoveryResponseCb(const ::boost::shared_ptr< StopDiscoveryResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onRemoveDeviceErrorCb(const ::boost::shared_ptr< RemoveDeviceError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onRemoveDeviceResponseCb(const ::boost::shared_ptr< RemoveDeviceResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onCreateDeviceErrorCb(const ::boost::shared_ptr< CreateDeviceError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onCreateDeviceResponseCb(const ::boost::shared_ptr< CreateDeviceResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSendHCICmdErrorCb(const ::boost::shared_ptr< SendHCICmdError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onSendHCICmdResponseCb(const ::boost::shared_ptr< SendHCICmdResponse >& response, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAdapterInitializationErrorCb(const ::boost::shared_ptr< AdapterInitializationError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAdapterInitializationSignalCb(const ::boost::shared_ptr< AdapterInitializationSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceCreatedErrorCb(const ::boost::shared_ptr< DeviceCreatedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceCreatedSignalCb(const ::boost::shared_ptr< DeviceCreatedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceRemovedErrorCb(const ::boost::shared_ptr< DeviceRemovedError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceRemovedSignalCb(const ::boost::shared_ptr< DeviceRemovedSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onBtStackLogErrorCb(const ::boost::shared_ptr< BtStackLogError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onBtStackLogSignalCb(const ::boost::shared_ptr< BtStackLogSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onHCIEventErrorCb(const ::boost::shared_ptr< HCIEventError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onHCIEventSignalCb(const ::boost::shared_ptr< HCIEventSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceFoundErrorCb(const ::boost::shared_ptr< DeviceFoundError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDeviceFoundSignalCb(const ::boost::shared_ptr< DeviceFoundSignal >& signal, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAddressErrorCb(const ::boost::shared_ptr< AddressError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAddressUpdateCb(const ::boost::shared_ptr< AddressUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onClassErrorCb(const ::boost::shared_ptr< ClassError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onClassUpdateCb(const ::boost::shared_ptr< ClassUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAliasErrorCb(const ::boost::shared_ptr< AliasError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAliasUpdateCb(const ::boost::shared_ptr< AliasUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPoweredErrorCb(const ::boost::shared_ptr< PoweredError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPoweredUpdateCb(const ::boost::shared_ptr< PoweredUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoverableErrorCb(const ::boost::shared_ptr< DiscoverableError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoverableUpdateCb(const ::boost::shared_ptr< DiscoverableUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoverableTimeoutErrorCb(const ::boost::shared_ptr< DiscoverableTimeoutError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoverableTimeoutUpdateCb(const ::boost::shared_ptr< DiscoverableTimeoutUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPairableErrorCb(const ::boost::shared_ptr< PairableError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPairableUpdateCb(const ::boost::shared_ptr< PairableUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPairableTimeoutErrorCb(const ::boost::shared_ptr< PairableTimeoutError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onPairableTimeoutUpdateCb(const ::boost::shared_ptr< PairableTimeoutUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoveringErrorCb(const ::boost::shared_ptr< DiscoveringError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onDiscoveringUpdateCb(const ::boost::shared_ptr< DiscoveringUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onUUIDsErrorCb(const ::boost::shared_ptr< UUIDsError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onUUIDsUpdateCb(const ::boost::shared_ptr< UUIDsUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onWBSModeErrorCb(const ::boost::shared_ptr< WBSModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onWBSModeUpdateCb(const ::boost::shared_ptr< WBSModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onConnectableErrorCb(const ::boost::shared_ptr< ConnectableError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onConnectableUpdateCb(const ::boost::shared_ptr< ConnectableUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onHCIModeErrorCb(const ::boost::shared_ptr< HCIModeError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onHCIModeUpdateCb(const ::boost::shared_ptr< HCIModeUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onVersionErrorCb(const ::boost::shared_ptr< VersionError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onVersionUpdateCb(const ::boost::shared_ptr< VersionUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onTraceLevelErrorCb(const ::boost::shared_ptr< TraceLevelError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onTraceLevelUpdateCb(const ::boost::shared_ptr< TraceLevelUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onTraceCategoryErrorCb(const ::boost::shared_ptr< TraceCategoryError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onTraceCategoryUpdateCb(const ::boost::shared_ptr< TraceCategoryUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAvailableSPPServersErrorCb(const ::boost::shared_ptr< AvailableSPPServersError >& error, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());

   virtual void onAvailableSPPServersUpdateCb(const ::boost::shared_ptr< AvailableSPPServersUpdate >& update, const ::std::string& objPath = ::std::string(), const ::std::string& busName = ::std::string(), const DbusBusType busType = BUS_TYPE_SYSTEM, const ::std::string& interfaceName = ::std::string());
   // IEvolutionGeniviDbusAdapterCallbackIf implementation --- end

protected:
   virtual void internalCreateProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyProxy(const unsigned int callbackId, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   virtual void internalDestroyAllProxies(void);

   virtual void internalDestroyAllRuntimeProxies(void);

   void internalOnAvailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);

   void internalOnUnavailable(const bool available, const ::std::string& objPath, const ::std::string& busName, const DbusBusType busType);
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_ADAPTER_PROXY_IF_H_
