/**
 * @file EvolutionGeniviDbusAdapterProperties.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi DBUS Properties for Adapter.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi DBUS Properties for Adapter.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_ADAPTER_PROPERTIES_H_
#define _EVOLUTION_GENIVI_DBUS_ADAPTER_PROPERTIES_H_

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * Adapter properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusAdapterProperties : public DbusProperties
{
public:
   EvolutionGeniviDbusAdapterProperties();
   virtual ~EvolutionGeniviDbusAdapterProperties();

   AdapterProperty getProperty2Enum(const ::std::string& value) const;
   const ::std::string& getProperty2String(const AdapterProperty value) const;
   const ::std::string& getProperty2StringTrace(const AdapterProperty value) const;

private:
   //------------------------------------------------------------------------------
   //    <property name="Address" type="s" access="read"/>
   // '   <property name=\"(.*)\" type=\".*\" access=\".*\".*' => '   const ::std::string _property$1;'
   //------------------------------------------------------------------------------
   const ::std::string _propertyAddress;
   const ::std::string _propertyClass;
   const ::std::string _propertyAlias;
   const ::std::string _propertyPowered;
   const ::std::string _propertyDiscoverable;
   const ::std::string _propertyDiscoverableTimeout;
   const ::std::string _propertyPairable;
   const ::std::string _propertyPairableTimeout;
   const ::std::string _propertyDiscovering;
   const ::std::string _propertyUUIDs;
   const ::std::string _propertyWBSMode;
   const ::std::string _propertyConnectable;
   const ::std::string _propertyHCIMode;
   const ::std::string _propertyVersion;
   const ::std::string _propertyVersionCode;
   const ::std::string _propertyVersionGeniviVersion;
   const ::std::string _propertyVersionEvoVersion;
   const ::std::string _propertyTraceLevel;
   const ::std::string _propertyTraceCategory;
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_ADAPTER_PROPERTIES_H_
