/**
 * @file EvolutionGeniviDbusAdapterFactory.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EvolutionGenivi instance factory for Adapter.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EvolutionGenivi instance factory for Adapter.
 */

#ifndef _EVOLUTION_GENIVI_DBUS_ADAPTER_FACTORY_H_
#define _EVOLUTION_GENIVI_DBUS_ADAPTER_FACTORY_H_

#include "IEvolutionGeniviDbusAdapterSendRequestIf.h"

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusAdapterTestProxyIf;
class ICcDbusIfControllerClient;

namespace evolution {

/**
 *
 */
class EvolutionGeniviDbusAdapterFactory
{
public:
   /**
    * Get instance of factory (reference).
    *
    * @return = reference to factory object
    */
   static EvolutionGeniviDbusAdapterFactory& getInstance(void);

   /**
    * Get proxy (pointer).
    *
    * @param[in] client: controller client
    *
    * @return = pointer to proxy
    */
   IEvolutionGeniviDbusAdapterSendRequestIf* getProxy(ICcDbusIfControllerClient* client);

   /**
    * Destroy proxy (pointer).
    */
   void destroyProxy(void);

   /**
    * Set test proxy (pointer).
    * For testing purpose (unit test).
    *
    * @param[in] testProxy: test version of proxy (pointer)
    */
   void setProxyForTesting(IEvolutionGeniviDbusAdapterTestProxyIf* testProxy);

private:
   /**
    * Default constructor. Private!!!
    */
   EvolutionGeniviDbusAdapterFactory();

   /**
    * Destructor. Private!!!
    */
   virtual ~EvolutionGeniviDbusAdapterFactory();

   IEvolutionGeniviDbusAdapterSendRequestIf* _proxy; /**< proxy */
   IEvolutionGeniviDbusAdapterTestProxyIf* _testProxy; /**< test proxy */
};

} //evolution
} //ccdbusif

#endif //_EVOLUTION_GENIVI_DBUS_ADAPTER_FACTORY_H_
