/**
 * @file EcNrWorkItem.h
 *
 * @par SW-Component
 * WorkItem
 *
 * @brief EcNr work item.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Work item handling for EcNr.
 */

#ifndef _ECNR_WORK_ITEM_H_
#define _ECNR_WORK_ITEM_H_

#include "IWorkItem.h"
#include "EcNrTypes.h"

namespace ccdbusif {

// class forward declarations
class IEcNrDbusServiceSendRequestIf;
class EcNrWrapper;

/**
 *
 */
class EcNrWorkItem : public IWorkItem
{
public:
   EcNrWorkItem();
   virtual ~EcNrWorkItem();
   virtual void processWorkItem(void);

   inline void setHandleSendRequest(IN const bool enable) { _handleSendRequest = enable; }
   inline void setServiceIf(IN IEcNrDbusServiceSendRequestIf* serviceIf) { _ecnrServiceIf = serviceIf; }
   inline void setWrapper(IN EcNrWrapper* wrapper) { _ecnrWrapper = wrapper; }
   inline void setEventType(IN const EcnrEventType type) { _eventType = type; }
   inline void setAppId(IN const EcnrAppId id) { _appId = id; }
   inline void setConfigurationId(IN const EcnrConfigurationId id) { _configurationId = id; }
   inline void setSendMuteSwitch(IN const EcnrSendMuteSwitch muteSwitch) { _sendMuteSwitch = muteSwitch; }

private:
   bool _handleSendRequest;
   IEcNrDbusServiceSendRequestIf* _ecnrServiceIf;
   EcNrWrapper* _ecnrWrapper;
   EcnrEventType _eventType;
   EcnrAppId _appId;
   EcnrConfigurationId _configurationId;
   EcnrSendMuteSwitch _sendMuteSwitch;

   void processSendRequest(void);
   void processSendRequestFailed(void);
};

} //ccdbusif

#endif //_ECNR_WORK_ITEM_H_
