/**
 * @file EcNrTypes.h
 *
 * @par SW-Component
 * Types
 *
 * @brief EcNr types.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Definitions of all types needed for EcNr.
 */

#ifndef _ECNR_TYPES_H_
#define _ECNR_TYPES_H_

#include <vector>
#include <string>
#include <stdbool.h> // <cstdbool> is marked with C++11

/*
 * RULE 1: use a class instead of declaring a struct (avoiding problems with copy actions), implement copy constructor, assignment operator and equality/inequality operator
 *
 * keep following order:
 * - class forward declarations
 * - defines (if really necessary)
 * - typedefs
 * - enums
 * - structs => classes
 */

#ifndef IN
#define IN /**< direction marker for input parameter */
#endif
#ifndef OUT
#define OUT /**< direction marker for output parameter */
#endif

/**
 * Type definition for EcNr App Id.
 */
typedef unsigned char EcnrAppId;

/**
 * Type definition for EcNr Configuration Id.
 */
typedef unsigned int EcnrConfigurationId;

/**
 * Type definition for EcNr Send Mute Switch.
 */
typedef unsigned char EcnrSendMuteSwitch;

/**
 * Type definition for common result of a request.
 */
enum EcnrRequestResult
{
   ECNR_REQ_SUCCESS = 0, /**< OK, must be the first code */
   ECNR_REQ_FAILED, /**< general error */
   // -------------------------------------------------------------------------
   ECNR_REQ_LAST /**< end marker, must be the last one */
};

/**
 * Error codes in EcNr implementation.
 */
enum EcnrErrorCode
{
   ECNR_OK = 0, /**< OK, must be the first code */
   ECNR_ERROR, /**< general error */
   // -------------------------------------------------------------------------
   ECNR_LAST /**< end marker, must be the last one */
};

/**
 * Event types in EcNr implementation.
 */
enum EcnrEventType
{
   ECNR_EVENT_NOTAVAILABLE = 0, /**< EcNr event is not available */
   ECNR_EVENT_INITIALIZE, /**< EcNr initialize event */
   ECNR_EVENT_DESTROY, /**< EcNr destroy event */
   ECNR_EVENT_CONFIGURATION, /**< EcNr configuration event */
   ECNR_EVENT_STARTAUDIO, /**< EcNr start audio event */
   ECNR_EVENT_STOPAUDIO, /**< EcNr stop audio event */
   ECNR_EVENT_MUTESWITCH, /**< EcNr send mute switch event */
   ECNR_EVENT_GETVERSION /**< EcNr get version event */
};

#endif // _ECNR_TYPES_H_
