/**
 * @file EcNrDbusServiceProxyIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EcNr DBUS Proxy.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details EcNr DBUS Proxy.
 */

#ifndef _I_ECNR_DBUS_SERVICE_PROXY_IF_H_
#define _I_ECNR_DBUS_SERVICE_PROXY_IF_H_

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IEcNrDbusServiceSendRequestIf.h"

#include <stdbool.h> // <cstdbool> is marked with C++11

#include "asf/core/Proxy.h"

#include "org/bosch/ecnr/serviceProxy.h"

using namespace ::org::bosch::ecnr::service;

using namespace ::asf::core;

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class IEcNrDbusServiceSendRequestIf;

/**
 *
 */
class EcNrDbusServiceProxyIf :
   public ServiceAvailableIF,
   public ICcDbusIfCreateProxy,
   public ICcDbusIfDestroyProxy,
   public IEcNrDbusServiceSendRequestIf
{
public:
   EcNrDbusServiceProxyIf(ICcDbusIfControllerClient* client);
   virtual ~EcNrDbusServiceProxyIf();

   virtual void createProxy(void);

   virtual void destroyProxy(void);

   virtual void destroyAllRuntimeProxies(void);

   virtual void setCallbackIf(IEcNrDbusServiceCallbackIf* callbackIf, bool enableServiceProxy);

   // ServiceAvailableIF implementation --- start
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   // ServiceAvailableIF implementation --- end

   // IEcNrDbusServiceSendRequestIf implementation --- start
   virtual act_t sendEcnrInitializeRequest(uint8 ecnrAppId, uint32 ecnrConfigurationId);

   virtual act_t sendEcnrDestroyRequest(uint8 ecnrAppId);

   virtual act_t sendEcnrSetConfigurationRequest(uint8 ecnrAppId, uint32 ecnrConfigurationId);

   virtual act_t sendEcnrStartAudioRequest(uint8 ecnrAppId);

   virtual act_t sendEcnrStopAudioRequest(uint8 ecnrAppId);

   virtual act_t sendEcnrSetSendMuteSwitchRequest(uint8 ecnrAppId, uint8 ecnrSendMuteSwitch);

   virtual act_t sendEcnrGetVersionRequest(void);
   // IEcNrDbusServiceSendRequestIf implementation --- end

protected:
   EcNrDbusServiceProxyIf();

private:
   bool _enableServiceProxy;

   ::boost::shared_ptr< ::org::bosch::ecnr::service::ServiceProxy > _serviceProxy;

   ICcDbusIfControllerClient* _controllerClient;
   IEcNrDbusServiceCallbackIf* _callbackIf;
};

} //ccdbusif

#endif // _I_ECNR_DBUS_SERVICE_PROXY_IF_H_
