/**
 * @file EcNrDbusServiceCallbackIf.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief EcNr DBUS Callback Interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface definition for EcNr DBUS callbacks.
 */

#ifndef _ECNR_DBUS_SERVICE_CALLBACK_IF_H_
#define _ECNR_DBUS_SERVICE_CALLBACK_IF_H_

#include "org/bosch/ecnr/serviceProxy.h"
#include "IEcNrDbusServiceCallbackIf.h"

using namespace ::org::bosch::ecnr::service;

#include <string>

namespace ccdbusif {

class EcNrWrapper;

/**
 *
 */
class EcNrDbusServiceCallbackIf : public IEcNrDbusServiceCallbackIf
{
public:
   EcNrDbusServiceCallbackIf(EcNrWrapper* ecnrWrapper);
   virtual ~EcNrDbusServiceCallbackIf();

   // "ServiceAvailableIF" implementation --- start
   virtual void onServiceProxyAvailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   virtual void onServiceProxyUnavailable(const ServiceState previousState, const ServiceState currentState, const ::std::string& objPath);
   // "ServiceAvailableIF" implementation --- end

   // serviceProxy implementation --- start
   virtual void onEcnrDestroyError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrDestroyError >& error);
   virtual void onEcnrDestroyResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrDestroyResponse >& response);
   virtual void onEcnrInitializeError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrInitializeError >& error);
   virtual void onEcnrInitializeResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrInitializeResponse >& response);
   virtual void onEcnrSetConfigurationError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetConfigurationError >& error);
   virtual void onEcnrSetConfigurationResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetConfigurationResponse >& response);
   virtual void onEcnrSetSendMuteSwitchError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetSendMuteSwitchError >& error);
   virtual void onEcnrSetSendMuteSwitchResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrSetSendMuteSwitchResponse >& response);
   virtual void onEcnrStartAudioError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStartAudioError >& error);
   virtual void onEcnrStartAudioResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStartAudioResponse >& response);
   virtual void onEcnrStopAudioError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStopAudioError >& error);
   virtual void onEcnrStopAudioResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrStopAudioResponse >& response);
   virtual void onEcnrGetVersionError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrGetVersionError >& error);
   virtual void onEcnrGetVersionResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< EcnrGetVersionResponse >& response);
   // serviceProxy implementation --- end

protected:
   EcNrDbusServiceCallbackIf();

private:
   EcNrWrapper* _ecnrWrapper;
};

} //ccdbusif

#endif // _ECNR_DBUS_SERVICE_CALLBACK_IF_H_
