/**
 * @file CcDbusIfDestroyAllProxiesWorkItem.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Destroy all proxies work item.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Destroy all proxies work item.
 */

#include "CcDbusIfDestroyAllProxiesWorkItem.h"
#include "ICcDbusIfControllerDestroyAllProxies.h"

#include <cstddef>

namespace ccdbusif {

CcDbusIfDestroyAllProxiesWorkItem::CcDbusIfDestroyAllProxiesWorkItem()
{
   _destroyer = NULL;
}

CcDbusIfDestroyAllProxiesWorkItem::CcDbusIfDestroyAllProxiesWorkItem(ICcDbusIfControllerDestroyAllProxies* destroyer)
{
   _destroyer = destroyer;
}

CcDbusIfDestroyAllProxiesWorkItem::~CcDbusIfDestroyAllProxiesWorkItem()
{
   _destroyer = NULL;
}

void CcDbusIfDestroyAllProxiesWorkItem::processWorkItem(void)
{
   if(NULL != _destroyer)
   {
      _destroyer->destroyAllProxies();
   }
}

} //ccdbusif
