/**
 * @file CcDbusIfCreateRuntimeProxyWorkItem.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create runtime proxy work item.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Create runtime proxy work item.
 */

#include "CcDbusIfCreateRuntimeProxyWorkItem.h"
#include "ICcDbusIfCreateRuntimeProxy.h"

#include <cstddef>

namespace ccdbusif {

CcDbusIfCreateRuntimeProxyWorkItem::CcDbusIfCreateRuntimeProxyWorkItem()
{
   // _objPath
   _proxyCreator = NULL;
}

CcDbusIfCreateRuntimeProxyWorkItem::CcDbusIfCreateRuntimeProxyWorkItem(const ::std::string& objPath, ICcDbusIfCreateRuntimeProxy* creator)
{
   _objPath = objPath;
   _proxyCreator = creator;
}

CcDbusIfCreateRuntimeProxyWorkItem::~CcDbusIfCreateRuntimeProxyWorkItem()
{
   _proxyCreator = NULL;
}

void CcDbusIfCreateRuntimeProxyWorkItem::processWorkItem(void)
{
   if(NULL != _proxyCreator)
   {
      _proxyCreator->createRuntimeProxy(_objPath);
   }
}

} //ccdbusif
