/**
 * @file CcDbusIfCreateProxyWorkItem.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Create proxy work item.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Create proxy work item.
 */

#include "CcDbusIfCreateProxyWorkItem.h"
#include "ICcDbusIfCreateProxy.h"

#include <cstddef>

namespace ccdbusif {

CcDbusIfCreateProxyWorkItem::CcDbusIfCreateProxyWorkItem()
{
   _proxyCreator = NULL;
}

CcDbusIfCreateProxyWorkItem::CcDbusIfCreateProxyWorkItem(ICcDbusIfCreateProxy* creator)
{
   _proxyCreator = creator;
}

CcDbusIfCreateProxyWorkItem::~CcDbusIfCreateProxyWorkItem()
{
   _proxyCreator = NULL;
}

void CcDbusIfCreateProxyWorkItem::processWorkItem(void)
{
   if(NULL != _proxyCreator)
   {
      _proxyCreator->createProxy();
   }
}

} //ccdbusif
