/**
 * @file CcDbusIfControllerFactory.cpp
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller Factory.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller Factory for CcDbusIf.
 */

#include "CcDbusIfControllerFactory.h"
#include "CcDbusIfController.h"

namespace ccdbusif {

CcDbusIfControllerFactory::CcDbusIfControllerFactory()
{
   _controllerCreatedLocally = true;
   _controllerIf = NULL;
}

CcDbusIfControllerFactory::~CcDbusIfControllerFactory()
{
   _controllerIf = NULL;
}

CcDbusIfControllerFactory& CcDbusIfControllerFactory::getInstance(void)
{
   static CcDbusIfControllerFactory factory;
   return factory;
}

ICcDbusIfController* CcDbusIfControllerFactory::getControllerInstance(void)
{
   if(NULL != _controllerIf)
   {
      // already created
   }
   else
   {
      _controllerIf = new CcDbusIfController();
      _controllerCreatedLocally = true;
   }

   return _controllerIf;
}

void CcDbusIfControllerFactory::destroyControllerInstance(void)
{
   if((NULL != _controllerIf) && (true == _controllerCreatedLocally))
   {
      delete _controllerIf;
      _controllerIf = NULL;
   }
}

void CcDbusIfControllerFactory::setControllerInstanceForTesting(ICcDbusIfController* testInstance)
{
   if(NULL != _controllerIf)
   {
      // not allowed because already set => to be considered by unit test
   }
   else
   {
      _controllerIf = testInstance;
      _controllerCreatedLocally = false;
   }
}

} //ccdbusif
