/**
 * @file ICcDbusIfDestroyRuntimeProxy.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Destroy Runtime Proxy.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Destroy runtime proxy for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_DESTROY_RUNTIME_PROXY_H_
#define _I_CC_DBUS_IF_DESTROY_RUNTIME_PROXY_H_

#include <string>

namespace ccdbusif {

/**
 *
 */
class ICcDbusIfDestroyRuntimeProxy
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfDestroyRuntimeProxy() {}

   /**
    * Destroy proxy.
    */
   virtual void destroyRuntimeProxy(const ::std::string& objPath) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_DESTROY_RUNTIME_PROXY_H_
