/**
 * @file ICcDbusIfControllerWbl.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller WBL IF.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller for WBL IF for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_CONTROLLER_WBL_H_
#define _I_CC_DBUS_IF_CONTROLLER_WBL_H_

namespace ccdbusif {

// class forward declarations
class IWblDbusLastIntendedModeSendRequestIf;
class IWblDbusConflictManagementSendRequestIf;
class IWblDbusWifiSetupSendRequestIf;

/**
 *
 */
class ICcDbusIfControllerWbl
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfControllerWbl() {}

   virtual IWblDbusLastIntendedModeSendRequestIf* getWblLastIntendedModeProxy(void) = 0;
   virtual IWblDbusConflictManagementSendRequestIf* getWblConflictManagementProxy(void) = 0;
   virtual IWblDbusWifiSetupSendRequestIf* getWblWifiSetupProxy(void) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_CONTROLLER_WBL_H_
