/**
 * @file ICcDbusIfControllerEvolutionGenivi.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller EvolutionGenivi interface.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller for EvolutionGenivi interface for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_CONTROLLER_EVOLUTION_GENIVI_H_
#define _I_CC_DBUS_IF_CONTROLLER_EVOLUTION_GENIVI_H_

namespace ccdbusif {

// class forward declarations
class IEvolutionGeniviDbusAdapterSendRequestIf;
class IEvolutionGeniviDbusDeviceSendRequestIf;
class IEvolutionGeniviDbusAgentManagerSendRequestIf;
class IEvolutionGeniviDbusDMSendRequestIf;
class IEvolutionGeniviDbusServiceSendRequestIf;
class IEvolutionGeniviDbusTraceSendRequestIf;
class IEvolutionGeniviDbusGeniviTraceSendRequestIf;
class IEvolutionGeniviDbusAgentSendRequestIf;
class IEvolutionGeniviDbusDidSendRequestIf;
class IEvolutionGeniviDbusSppSendRequestIf;
class IEvolutionGeniviDbusObexClientSendRequestIf;
class IEvolutionGeniviDbusObexSessionSendRequestIf;
class IEvolutionGeniviDbusObexTransferSendRequestIf;
class IEvolutionGeniviDbusHfpCallVolumeSendRequestIf;
class IEvolutionGeniviDbusHfpHandsfreeSendRequestIf;
class IEvolutionGeniviDbusHfpManagerSendRequestIf;
class IEvolutionGeniviDbusHfpModemSendRequestIf;
class IEvolutionGeniviDbusHfpNetworkOperatorSendRequestIf;
class IEvolutionGeniviDbusHfpNetworkRegistrationSendRequestIf;
class IEvolutionGeniviDbusHfpSiriSendRequestIf;
class IEvolutionGeniviDbusHfpVoiceCallManagerSendRequestIf;
class IEvolutionGeniviDbusHfpVoiceCallSendRequestIf;
class IEvolutionGeniviDbusSerialSendRequestIf;
class IEvolutionGeniviDbusLEAdapterSendRequestIf;
class IEvolutionGeniviDbusLEDeviceSendRequestIf;
class IEvolutionGeniviDbusLESeamlessPairingSendRequestIf;

/**
 *
 */
class ICcDbusIfControllerEvolutionGenivi
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfControllerEvolutionGenivi() {}

   virtual IEvolutionGeniviDbusAdapterSendRequestIf* getEvolutionGeniviAdapterProxy(void) = 0;
   virtual IEvolutionGeniviDbusDeviceSendRequestIf* getEvolutionGeniviDeviceProxy(void) = 0;
   virtual IEvolutionGeniviDbusAgentManagerSendRequestIf* getEvolutionGeniviAgentManagerProxy(void) = 0;
   virtual IEvolutionGeniviDbusDMSendRequestIf* getEvolutionGeniviDMProxy(void) = 0;
   virtual IEvolutionGeniviDbusServiceSendRequestIf* getEvolutionGeniviServiceProxy(void) = 0;
   virtual IEvolutionGeniviDbusTraceSendRequestIf* getEvolutionGeniviTraceProxy(void) = 0;
   virtual IEvolutionGeniviDbusGeniviTraceSendRequestIf* getEvolutionGeniviGeniviTraceProxy(void) = 0;
   virtual IEvolutionGeniviDbusAgentSendRequestIf* getEvolutionGeniviAgentStub(void) = 0;
   virtual IEvolutionGeniviDbusDidSendRequestIf* getEvolutionGeniviDidProxy(void) = 0;
   virtual IEvolutionGeniviDbusSppSendRequestIf* getEvolutionGeniviSppProxy(void) = 0;
   virtual IEvolutionGeniviDbusObexClientSendRequestIf* getEvolutionGeniviObexClientProxy(void) = 0;
   virtual IEvolutionGeniviDbusObexSessionSendRequestIf* getEvolutionGeniviObexSessionProxy(void) = 0;
   virtual IEvolutionGeniviDbusObexTransferSendRequestIf* getEvolutionGeniviObexTransferProxy(void) = 0;
   virtual IEvolutionGeniviDbusHfpCallVolumeSendRequestIf* getEvolutionGeniviHfpCallVolumeProxy(void) = 0;
   virtual IEvolutionGeniviDbusHfpHandsfreeSendRequestIf* getEvolutionGeniviHfpHandsfreeProxy(void) = 0;
   virtual IEvolutionGeniviDbusHfpManagerSendRequestIf* getEvolutionGeniviHfpManagerProxy(void) = 0;
   virtual IEvolutionGeniviDbusHfpModemSendRequestIf* getEvolutionGeniviHfpModemProxy(void) = 0;
   virtual IEvolutionGeniviDbusHfpNetworkOperatorSendRequestIf* getEvolutionGeniviHfpNetworkOperatorProxy(void) = 0;
   virtual IEvolutionGeniviDbusHfpNetworkRegistrationSendRequestIf* getEvolutionGeniviHfpNetworkRegistrationProxy(void) = 0;
   virtual IEvolutionGeniviDbusHfpSiriSendRequestIf* getEvolutionGeniviHfpSiriProxy(void) = 0;
   virtual IEvolutionGeniviDbusHfpVoiceCallManagerSendRequestIf* getEvolutionGeniviHfpVoiceCallManagerProxy(void) = 0;
   virtual IEvolutionGeniviDbusHfpVoiceCallSendRequestIf* getEvolutionGeniviHfpVoiceCallProxy(void) = 0;
   virtual IEvolutionGeniviDbusSerialSendRequestIf* getEvolutionGeniviSerialProxy(void) = 0;
   virtual IEvolutionGeniviDbusLEAdapterSendRequestIf* getEvolutionGeniviLEAdapterProxy(void) = 0;
   virtual IEvolutionGeniviDbusLEDeviceSendRequestIf* getEvolutionGeniviLEDeviceProxy(void) = 0;
   virtual IEvolutionGeniviDbusLESeamlessPairingSendRequestIf* getEvolutionGeniviLESeamlessPairingProxy(void) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_CONTROLLER_EVOLUTION_GENIVI_H_
