/**
 * @file ICcDbusIfControllerConnMan.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller ConnMan interface.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller for ConnMan interface for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_CONTROLLER_CONN_MAN_H_
#define _I_CC_DBUS_IF_CONTROLLER_CONN_MAN_H_

namespace ccdbusif {

// class forward declarations
class IConnManDbusManagerSendRequestIf;
class IConnManDbusServiceSendRequestIf;
class IConnManDbusTechnologySendRequestIf;

/**
 *
 */
class ICcDbusIfControllerConnMan
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfControllerConnMan() {}

   virtual IConnManDbusManagerSendRequestIf* getConnManManagerProxy(void) = 0;
   virtual IConnManDbusServiceSendRequestIf* getConnManServiceProxy(void) = 0;
   virtual IConnManDbusTechnologySendRequestIf* getConnManTechnologyProxy(void) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_CONTROLLER_CONN_MAN_H_
