/**
 * @file ICcDbusIfController.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Controller.
 *
 * @copyright (C) 2016 - 2018 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Controller for CcDbusIf.
 */

#ifndef _I_CC_DBUS_IF_CONTROLLER_H_
#define _I_CC_DBUS_IF_CONTROLLER_H_

#include "CcDbusIfLaunchType.h"
#include <string>

namespace ccdbusif {

// class forward declarations
class ICcDbusIfControllerClient;
class ICcDbusIfControllerConnMan;
class ICcDbusIfControllerEcNr;
class ICcDbusIfControllerEvolutionGenivi;
class ICcDbusIfControllerObjectManager;
class ICcDbusIfControllerIntrospectable;
class ICcDbusIfControllerPropertiesGetAll;
class ICcDbusIfControllerWbl;

/**
 *
 */
class ICcDbusIfController
{
public:
   /**
    * Destructor.
    */
   virtual ~ICcDbusIfController() {}

   virtual void start(void) = 0;
   virtual void stop(void) = 0;
   virtual void startDbusLauncher(const LaunchType launchType, const ::std::string& configFile) = 0;
   virtual void stopDbusLauncher(void) = 0;
   virtual void prepareStop(void) = 0;
   virtual unsigned int getCallbackId(void) = 0;
   virtual ICcDbusIfControllerClient* getCcDbusIfControllerClient(void) = 0;
   virtual ICcDbusIfControllerConnMan* getCcDbusIfControllerConnMan(void) = 0;
   virtual ICcDbusIfControllerEcNr* getCcDbusIfControllerEcNr(void) = 0;
   virtual ICcDbusIfControllerEvolutionGenivi* getCcDbusIfControllerEvolutionGenivi(void) = 0;
   virtual ICcDbusIfControllerObjectManager* getCcDbusIfControllerObjectManager(void) = 0;
   virtual ICcDbusIfControllerIntrospectable* getCcDbusIfControllerIntrospectable(void) = 0;
   virtual ICcDbusIfControllerPropertiesGetAll* getCcDbusIfControllerPropertiesGetAll(void) = 0;
   virtual ICcDbusIfControllerWbl* getCcDbusIfControllerWbl(void) = 0;
};

} //ccdbusif

#endif //_I_CC_DBUS_IF_CONTROLLER_H_
