/**
 * @file CcDbusIfWorkItemQueue.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief Work Item Queue.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Work item queue for CcDbusIf.
 */

#ifndef _CC_DBUS_IF_WORK_ITEM_QUEUE_H_
#define _CC_DBUS_IF_WORK_ITEM_QUEUE_H_

#include "FwLock.h"

#include <semaphore.h>
#include <list>

namespace ccdbusif {

// class forward declarations
class IWorkItem;

/**
 *
 */
class CcDbusIfWorkItemQueue
{
public:
   CcDbusIfWorkItemQueue();
   virtual ~CcDbusIfWorkItemQueue();

   void push(IWorkItem* workItem);
   void pushAndPost(IWorkItem* workItem);
   IWorkItem* pop(void);
   IWorkItem* waitAndPop(void);
   void empty(void);

private:
   ::std::list<IWorkItem*> _queue;
   sem_t _semaphore;
   LockForeverAndNonReentrant _lock;
};

} //ccdbusif

#endif //_CC_DBUS_IF_WORK_ITEM_QUEUE_H_
