/**
 * @file CcDbusIfLauncher.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief ASF DBUS Launcher.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Launcher for ASF DBUS handling.
 */

#ifndef _CC_DBUS_IF_LAUNCHER_H_
#define _CC_DBUS_IF_LAUNCHER_H_

#include "asf/core/ApplicationLauncher.h"

#include <stdbool.h> // <cstdbool> is marked with C++11

namespace ccdbusif {

/**
 *
 */
class CcDbusIfLauncher
{
public:
   CcDbusIfLauncher();
   virtual ~CcDbusIfLauncher();

   void start(::asf::core::ApplicationLauncher::mainfptr mainFunction);
   void start(::asf::core::ApplicationLauncher::mainfptr mainFunction, int argc, char** argv);
   void stop(void);

private:
   ::asf::core::ApplicationLauncher _launcher;
   bool _applicationLaunched;
};

} //ccdbusif

#endif //_CC_DBUS_IF_LAUNCHER_H_
